/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.ByteDataReader;
import btools.mapaccess.MicroCache;
import btools.mapaccess.PhysicalFile;
import btools.util.Crc32;
import java.io.IOException;
import java.io.RandomAccessFile;

final class OsmFile {
    private RandomAccessFile is = null;
    private long fileOffset;
    private int[] posIdx;
    public MicroCache[] microCaches;
    public int lonDegree;
    public int latDegree;
    public String filename;
    public boolean ghost = false;

    public OsmFile(PhysicalFile rafile, int tileIndex, byte[] iobuffer) throws Exception {
        if (rafile != null) {
            int headerCrc;
            this.filename = rafile.fileName;
            long[] index = rafile.fileIndex;
            long l = this.fileOffset = tileIndex > 0 ? index[tileIndex - 1] : 200L;
            if (this.fileOffset == index[tileIndex]) {
                return;
            }
            this.is = rafile.ra;
            this.posIdx = new int[6400];
            this.microCaches = new MicroCache[6400];
            this.is.seek(this.fileOffset);
            this.is.readFully(iobuffer, 0, 25600);
            if (rafile.fileHeaderCrcs != null && rafile.fileHeaderCrcs[tileIndex] != (headerCrc = Crc32.crc(iobuffer, 0, 25600))) {
                throw new IOException("sub index checksum error");
            }
            ByteDataReader dis = new ByteDataReader(iobuffer);
            for (int i = 0; i < 6400; ++i) {
                this.posIdx[i] = dis.readInt();
            }
        }
    }

    private int getPosIdx(int idx) {
        return idx == -1 ? 25600 : this.posIdx[idx];
    }

    public int getDataInputForSubIdx(int subIdx, byte[] iobuffer) throws Exception {
        int startPos = this.getPosIdx(subIdx - 1);
        int endPos = this.getPosIdx(subIdx);
        int size = endPos - startPos;
        if (size > 0) {
            this.is.seek(this.fileOffset + (long)startPos);
            if (size <= iobuffer.length) {
                this.is.readFully(iobuffer, 0, size);
            }
        }
        return size;
    }

    long setGhostState() {
        long sum = 0L;
        this.ghost = true;
        int nc = this.microCaches == null ? 0 : this.microCaches.length;
        for (int i = 0; i < nc; ++i) {
            MicroCache mc = this.microCaches[i];
            if (mc == null) continue;
            if (mc.virgin) {
                mc.ghost = true;
                sum += (long)mc.getDataSize();
                continue;
            }
            this.microCaches[i] = null;
        }
        return sum;
    }

    void cleanAll() {
        int nc = this.microCaches == null ? 0 : this.microCaches.length;
        for (int i = 0; i < nc; ++i) {
            MicroCache mc = this.microCaches[i];
            if (mc == null) continue;
            if (mc.ghost) {
                this.microCaches[i] = null;
                continue;
            }
            mc.collect();
        }
    }
}

