/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.CompactLongSet;

public class FrozenLongSet
extends CompactLongSet {
    private long[] faid;
    private int size = 0;
    private int p2size;

    public FrozenLongSet(CompactLongSet set) {
        this.size = set.size();
        this.faid = new long[this.size];
        set.moveToFrozenArray(this.faid);
        this.p2size = 0x40000000;
        while (this.p2size > this.size) {
            this.p2size >>= 1;
        }
    }

    @Override
    public boolean add(long id) {
        throw new RuntimeException("cannot add on FrozenLongSet");
    }

    @Override
    public void fastAdd(long id) {
        throw new RuntimeException("cannot add on FrozenLongSet");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(long id) {
        if (this.size == 0) {
            return false;
        }
        long[] a = this.faid;
        int offset = this.p2size;
        int n = 0;
        while (offset > 0) {
            int nn = n + offset;
            if (nn < this.size && a[nn] <= id) {
                n = nn;
            }
            offset >>= 1;
        }
        return a[n] == id;
    }
}

