/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

public class CompactLongSet {
    private long[][] al;
    private int[] pa = new int[31];
    private int size = 0;
    private int _maxKeepExponent = 14;
    protected static final int MAXLISTS = 31;
    private static boolean earlyDuplicateCheck;

    public CompactLongSet() {
        this.al = new long[31][];
        this.al[0] = new long[1];
        earlyDuplicateCheck = Boolean.getBoolean("earlyDuplicateCheck");
    }

    public int size() {
        return this.size;
    }

    public boolean add(long id) {
        if (this.contains(id)) {
            return true;
        }
        this._add(id);
        return false;
    }

    public void fastAdd(long id) {
        this._add(id);
    }

    private void _add(long id) {
        if (this.size == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("cannot grow beyond size Integer.MAX_VALUE");
        }
        this.al[0][0] = id;
        int bp = this.size++;
        int idx = 1;
        int n = 1;
        this.pa[0] = 1;
        this.pa[1] = 1;
        while ((bp & 1) == 1) {
            bp >>= 1;
            this.pa[idx++] = n;
            n <<= 1;
        }
        if (this.al[idx] == null) {
            this.al[idx] = new long[n];
        }
        while (n > 0) {
            long maxId = 0L;
            int maxIdx = -1;
            int i = 0;
            while (i < idx) {
                int p = this.pa[i];
                if (p > 0) {
                    long currentId = this.al[i][p - 1];
                    if (maxIdx < 0 || currentId > maxId) {
                        maxIdx = i;
                        maxId = currentId;
                    }
                }
                ++i;
            }
            if (n < this.al[idx].length && maxId == this.al[idx][n]) {
                throw new IllegalArgumentException("duplicate key found in late check: " + maxId);
            }
            this.al[idx][--n] = maxId;
            int n2 = maxIdx;
            this.pa[n2] = this.pa[n2] - 1;
        }
        while (idx-- > this._maxKeepExponent) {
            this.al[idx] = null;
        }
    }

    public boolean contains(long id) {
        int bp = this.size;
        int idx = 1;
        while (bp != 0) {
            if ((bp & 1) == 1 && this.contains(idx, id)) {
                return true;
            }
            ++idx;
            bp >>= 1;
        }
        return false;
    }

    private boolean contains(int idx, long id) {
        long[] a = this.al[idx];
        int offset = a.length;
        int n = 0;
        while ((offset >>= 1) > 0) {
            int nn = n + offset;
            if (a[nn] > id) continue;
            n = nn;
        }
        return a[n] == id;
    }

    protected void moveToFrozenArray(long[] faid) {
        int i = 1;
        while (i < 31) {
            this.pa[i] = 0;
            ++i;
        }
        int ti = 0;
        while (ti < this.size) {
            int bp = this.size;
            int minIdx = -1;
            long minId = 0L;
            int idx = 1;
            while (bp != 0) {
                int p;
                if ((bp & 1) == 1 && (p = this.pa[idx]) < this.al[idx].length) {
                    long currentId = this.al[idx][p];
                    if (minIdx < 0 || currentId < minId) {
                        minIdx = idx;
                        minId = currentId;
                    }
                }
                ++idx;
                bp >>= 1;
            }
            faid[ti] = minId;
            int n = minIdx;
            this.pa[n] = this.pa[n] + 1;
            if (ti > 0 && faid[ti - 1] == minId) {
                throw new IllegalArgumentException("duplicate key found in late check: " + minId);
            }
            ++ti;
        }
        this.al = null;
    }
}

