/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.expressions.BExpressionContext;
import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.OsmLinkP;
import btools.mapcreator.OsmNodeP;
import btools.mapcreator.OsmNodePT;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.CompactLongMap;
import btools.util.CompactLongSet;
import btools.util.FrozenLongMap;
import btools.util.FrozenLongSet;
import btools.util.LazyArrayOfLists;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.List;

public class WayLinker
extends MapCreatorBase {
    private File nodeTilesIn;
    private File dataTilesOut;
    private File borderFileIn;
    private String dataTilesSuffix;
    private boolean readingBorder;
    private CompactLongMap<OsmNodeP> nodesMap;
    private List<OsmNodeP> nodesList;
    private CompactLongSet borderSet;
    private short lookupVersion;
    private BExpressionContext expctxWay;
    private int minLon;
    private int minLat;

    private void reset() {
        this.minLon = -1;
        this.minLat = -1;
        this.nodesMap = new CompactLongMap();
        this.borderSet = new CompactLongSet();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("*** WayLinker: Format a regionof an OSM map for routing");
        if (args.length != 7) {
            System.out.println("usage: java WayLinker <node-tiles-in> <way-tiles-in> <bordernodes> <lookup-file> <profile-file> <data-tiles-out> <data-tiles-suffix> ");
            return;
        }
        new WayLinker().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), new File(args[4]), new File(args[5]), args[6]);
    }

    public void process(File nodeTilesIn, File wayTilesIn, File borderFileIn, File lookupFile, File profileFile, File dataTilesOut, String dataTilesSuffix) throws Exception {
        this.nodeTilesIn = nodeTilesIn;
        this.dataTilesOut = dataTilesOut;
        this.borderFileIn = borderFileIn;
        this.dataTilesSuffix = dataTilesSuffix;
        this.expctxWay = new BExpressionContext("way");
        this.expctxWay.readMetaData(lookupFile);
        this.lookupVersion = this.expctxWay.lookupVersion;
        this.expctxWay.parseFile(profileFile, "global");
        new WayIterator(this, true).processDir(wayTilesIn, ".wt5");
    }

    @Override
    public void wayFileStart(File wayfile) throws Exception {
        File nodeFile = this.fileFromTemplate(wayfile, this.nodeTilesIn, "u5d");
        if (nodeFile.exists()) {
            this.reset();
            this.readingBorder = true;
            new NodeIterator(this, false).processFile(this.borderFileIn);
            this.borderSet = new FrozenLongSet(this.borderSet);
            this.readingBorder = false;
            new NodeIterator(this, false).processFile(nodeFile);
            FrozenLongMap<OsmNodeP> nodesMapFrozen = new FrozenLongMap<OsmNodeP>(this.nodesMap);
            this.nodesMap = nodesMapFrozen;
            this.nodesList = nodesMapFrozen.getValueList();
        }
    }

    @Override
    public void nextNode(NodeData data) throws Exception {
        OsmNodeP n = data.description == 0L ? new OsmNodeP() : new OsmNodePT(data.description);
        n.ilon = data.ilon;
        n.ilat = data.ilat;
        n.selev = data.selev;
        n.isBorder = this.readingBorder;
        if (this.readingBorder || !this.borderSet.contains(data.nid)) {
            this.nodesMap.fastPut(data.nid, n);
        }
        if (this.readingBorder) {
            this.borderSet.fastAdd(data.nid);
            return;
        }
        int min_lon = n.ilon / 5000000 * 5000000;
        int min_lat = n.ilat / 5000000 * 5000000;
        if (this.minLon == -1) {
            this.minLon = min_lon;
        }
        if (this.minLat == -1) {
            this.minLat = min_lat;
        }
        if (this.minLat != min_lat || this.minLon != min_lon) {
            throw new IllegalArgumentException("inconsistent node: " + n.ilon + " " + n.ilat);
        }
    }

    @Override
    public void nextWay(WayData way) throws Exception {
        long description = way.description;
        long reverseDescription = description | 1L;
        this.expctxWay.evaluate(description, null);
        boolean ok = (double)this.expctxWay.getCostfactor() < 10000.0;
        this.expctxWay.evaluate(reverseDescription, null);
        if (!(ok |= (double)this.expctxWay.getCostfactor() < 10000.0)) {
            return;
        }
        byte lowbyte = (byte)description;
        OsmNodeP n1 = null;
        OsmNodeP n2 = null;
        int i = 0;
        while (i < way.nodes.size()) {
            long nid = way.nodes.get(i);
            n1 = n2;
            n2 = this.nodesMap.get(nid);
            if (n1 != null && n2 != null) {
                OsmLinkP l1 = new OsmLinkP();
                l1.targetNode = n2;
                l1.descriptionBitmap = description;
                n1.addLink(l1);
                OsmLinkP l2 = new OsmLinkP();
                l2.targetNode = n1;
                l2.descriptionBitmap = reverseDescription;
                n2.addLink(l2);
            }
            if (n2 != null) {
                n2.wayAndBits = (byte)(n2.wayAndBits & lowbyte);
                if (n2 instanceof OsmNodePT) {
                    ((OsmNodePT)n2).wayOrBits = (byte)(((OsmNodePT)n2).wayOrBits | lowbyte);
                }
            }
            ++i;
        }
    }

    @Override
    public void wayFileEnd(File wayfile) throws Exception {
        this.nodesMap = null;
        this.borderSet = null;
        int maxLon = this.minLon + 5000000;
        int maxLat = this.minLat + 5000000;
        int nLonSegs = (maxLon - this.minLon) / 1000000;
        int nLatSegs = (maxLat - this.minLat) / 1000000;
        LazyArrayOfLists seglists = new LazyArrayOfLists(nLonSegs * nLatSegs);
        for (OsmNodeP n : this.nodesList) {
            if (n == null || n.firstlink == null || n.isTransferNode() || n.ilon < this.minLon || n.ilon >= maxLon || n.ilat < this.minLat || n.ilat >= maxLat) continue;
            int lonIdx = (n.ilon - this.minLon) / 1000000;
            int latIdx = (n.ilat - this.minLat) / 1000000;
            int tileIndex = lonIdx * nLatSegs + latIdx;
            seglists.getList(tileIndex).add(n);
        }
        this.nodesList = null;
        seglists.trimAll();
        File outfile = this.fileFromTemplate(wayfile, this.dataTilesOut, this.dataTilesSuffix);
        DataOutputStream os = this.createOutStream(outfile);
        long[] fileIndex = new long[25];
        int i55 = 0;
        while (i55 < 25) {
            os.writeLong(0L);
            ++i55;
        }
        long filepos = 200L;
        int lonIdx = 0;
        while (lonIdx < nLonSegs) {
            int latIdx = 0;
            while (latIdx < nLatSegs) {
                int tileIndex = lonIdx * nLatSegs + latIdx;
                if (seglists.getSize(tileIndex) > 0) {
                    List nlist = seglists.getList(tileIndex);
                    LazyArrayOfLists subs = new LazyArrayOfLists(6400);
                    byte[][] subByteArrays = new byte[6400][];
                    int ni = 0;
                    while (ni < nlist.size()) {
                        OsmNodeP n = (OsmNodeP)nlist.get(ni);
                        int subLonIdx = (n.ilon - this.minLon) / 12500 - 80 * lonIdx;
                        int subLatIdx = (n.ilat - this.minLat) / 12500 - 80 * latIdx;
                        int si = subLatIdx * 80 + subLonIdx;
                        subs.getList(si).add(n);
                        ++ni;
                    }
                    subs.trimAll();
                    int[] posIdx = new int[6400];
                    int pos = 25600;
                    int si = 0;
                    while (si < 6400) {
                        List subList = subs.getList(si);
                        if (subList.size() > 0) {
                            Collections.sort(subList);
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            DataOutputStream dos = new DataOutputStream(bos);
                            dos.writeInt(subList.size());
                            int ni2 = 0;
                            while (ni2 < subList.size()) {
                                OsmNodeP n = (OsmNodeP)subList.get(ni2);
                                n.writeNodeData(dos);
                                ++ni2;
                            }
                            dos.close();
                            byte[] subBytes = bos.toByteArray();
                            pos += subBytes.length;
                            subByteArrays[si] = subBytes;
                        }
                        posIdx[si] = pos;
                        ++si;
                    }
                    si = 0;
                    while (si < 6400) {
                        os.writeInt(posIdx[si]);
                        ++si;
                    }
                    si = 0;
                    while (si < 6400) {
                        if (subByteArrays[si] != null) {
                            os.write(subByteArrays[si]);
                        }
                        ++si;
                    }
                    filepos += (long)pos;
                }
                fileIndex[tileIndex] = filepos;
                ++latIdx;
            }
            ++lonIdx;
        }
        os.close();
        RandomAccessFile ra = new RandomAccessFile(outfile, "rw");
        long versionPrefix = this.lookupVersion;
        versionPrefix <<= 48;
        int i552 = 0;
        while (i552 < 25) {
            ra.writeLong(fileIndex[i552] | versionPrefix);
            ++i552;
        }
        ra.close();
    }
}

