/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.NodeData;
import btools.mapcreator.NodeListener;
import btools.mapcreator.RelationData;
import btools.mapcreator.RelationListener;
import btools.mapcreator.WayData;
import btools.mapcreator.WayListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;

public abstract class MapCreatorBase
implements WayListener,
NodeListener,
RelationListener {
    private DataOutputStream[] tileOutStreams;
    protected File outTileDir;
    protected HashMap<String, String> tags;

    public void putTag(String key, String value) {
        if (this.tags == null) {
            this.tags = new HashMap();
        }
        this.tags.put(key, value);
    }

    public String getTag(String key) {
        return this.tags == null ? null : this.tags.get(key);
    }

    public HashMap<String, String> getTagsOrNull() {
        return this.tags;
    }

    public void setTags(HashMap<String, String> tags) {
        this.tags = tags;
    }

    protected static long readId(DataInputStream is) throws IOException {
        byte offset = is.readByte();
        if (offset == 32) {
            return -1L;
        }
        long i = is.readInt();
        return (i <<= 5) | (long)offset;
    }

    protected static void writeId(DataOutputStream o, long id) throws IOException {
        if (id == -1L) {
            o.writeByte(32);
            return;
        }
        int offset = (int)(id & 0x1FL);
        int i = (int)(id >> 5);
        o.writeByte(offset);
        o.writeInt(i);
    }

    protected static File[] sortBySizeAsc(File[] files) {
        int n = files.length;
        long[] sizes = new long[n];
        File[] sorted = new File[n];
        int i = 0;
        while (i < n) {
            sizes[i] = files[i].length();
            ++i;
        }
        int nf = 0;
        while (nf < n) {
            int idx = -1;
            long min = -1L;
            int i2 = 0;
            while (i2 < n) {
                if (sizes[i2] != -1L && (idx == -1 || sizes[i2] < min)) {
                    min = sizes[i2];
                    idx = i2;
                }
                ++i2;
            }
            sizes[idx] = -1L;
            sorted[nf] = files[idx];
            ++nf;
        }
        return sorted;
    }

    protected File fileFromTemplate(File template, File dir, String suffix) {
        String filename = template.getName();
        filename = String.valueOf(filename.substring(0, filename.length() - 3)) + suffix;
        return new File(dir, filename);
    }

    protected DataInputStream createInStream(File inFile) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(inFile)));
    }

    protected DataOutputStream createOutStream(File outFile) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outFile)));
    }

    protected DataOutputStream getOutStreamForTile(int tileIndex) throws Exception {
        if (this.tileOutStreams == null) {
            this.tileOutStreams = new DataOutputStream[64];
        }
        if (this.tileOutStreams[tileIndex] == null) {
            this.tileOutStreams[tileIndex] = this.createOutStream(new File(this.outTileDir, this.getNameForTile(tileIndex)));
        }
        return this.tileOutStreams[tileIndex];
    }

    protected String getNameForTile(int tileIndex) {
        throw new IllegalArgumentException("getNameForTile not implemented");
    }

    protected void closeTileOutStreams() throws Exception {
        if (this.tileOutStreams == null) {
            return;
        }
        int tileIndex = 0;
        while (tileIndex < this.tileOutStreams.length) {
            if (this.tileOutStreams[tileIndex] != null) {
                this.tileOutStreams[tileIndex].close();
            }
            this.tileOutStreams[tileIndex] = null;
            ++tileIndex;
        }
    }

    @Override
    public void nodeFileStart(File nodefile) throws Exception {
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
    }

    @Override
    public void nodeFileEnd(File nodefile) throws Exception {
    }

    @Override
    public void wayFileStart(File wayfile) throws Exception {
    }

    @Override
    public void nextWay(WayData data) throws Exception {
    }

    @Override
    public void wayFileEnd(File wayfile) throws Exception {
    }

    @Override
    public void nextRelation(RelationData data) throws Exception {
    }
}

