/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmPos;
import btools.router.MatchedWaypoint;
import btools.router.OsmNodeNamed;
import btools.router.OsmPathElement;
import btools.router.RoutingContext;
import btools.util.CompactLongMap;
import btools.util.FrozenLongMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;

public final class OsmTrack {
    public MatchedWaypoint endPoint;
    public ArrayList<OsmPathElement> nodes = new ArrayList();
    private CompactLongMap<OsmPathElementHolder> nodesMap;
    public String message = null;
    public ArrayList<String> messageList = null;
    public String name = "unset";
    public int distance;
    public int ascend;
    public int plainAscend;
    public int cost;

    public void addNode(OsmPathElement node) {
        this.nodes.add(0, node);
    }

    public void buildMap() {
        this.nodesMap = new CompactLongMap();
        for (OsmPathElement node : this.nodes) {
            long id = node.getIdFromPos();
            OsmPathElementHolder nh = new OsmPathElementHolder();
            nh.node = node;
            OsmPathElementHolder h = this.nodesMap.get(id);
            if (h != null) {
                while (h.nextHolder != null) {
                    h = h.nextHolder;
                }
                h.nextHolder = nh;
                continue;
            }
            this.nodesMap.fastPut(id, nh);
        }
        this.nodesMap = new FrozenLongMap<OsmPathElementHolder>(this.nodesMap);
    }

    public void writeBinary(String filename) throws Exception {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(filename)));
        this.endPoint.writeToStream(dos);
        dos.writeInt(this.nodes.size());
        for (OsmPathElement node : this.nodes) {
            node.writeToStream(dos);
        }
        dos.close();
    }

    public static OsmTrack readBinary(String filename, OsmNodeNamed newEp) {
        File f;
        OsmTrack t = null;
        if (filename != null && (f = new File(filename)).exists()) {
            try {
                DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f)));
                MatchedWaypoint ep = MatchedWaypoint.readFromStream(dis);
                int dlon = ep.waypoint.ilon - newEp.ilon;
                int dlat = ep.waypoint.ilat - newEp.ilat;
                if (dlon < 20 && dlon > -20 && dlat < 20 && dlat > -20) {
                    t = new OsmTrack();
                    t.endPoint = ep;
                    int n = dis.readInt();
                    OsmPathElement last_pe = null;
                    int i = 0;
                    while (i < n) {
                        OsmPathElement pe = OsmPathElement.readFromStream(dis);
                        pe.origin = last_pe;
                        last_pe = pe;
                        t.nodes.add(pe);
                        ++i;
                    }
                    t.cost = last_pe.cost;
                    t.buildMap();
                }
                dis.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Exception reading rawTrack: " + e);
            }
        }
        return t;
    }

    public void addNodes(OsmTrack t) {
        for (OsmPathElement n : t.nodes) {
            this.addNode(n);
        }
        this.buildMap();
    }

    public boolean containsNode(OsmPos node) {
        return this.nodesMap.contains(node.getIdFromPos());
    }

    public OsmPathElement getLink(long n1, long n2) {
        OsmPathElementHolder h = this.nodesMap.get(n2);
        while (h != null) {
            OsmPathElement e1 = h.node.origin;
            if (e1 != null && e1.getIdFromPos() == n1) {
                return h.node;
            }
            h = h.nextHolder;
        }
        return null;
    }

    public void appendTrack(OsmTrack t) {
        int i = 0;
        while (i < t.nodes.size()) {
            if (i > 0 || this.nodes.size() == 0) {
                this.nodes.add(t.nodes.get(i));
            }
            ++i;
        }
        this.distance += t.distance;
        this.ascend += t.ascend;
        this.plainAscend += t.plainAscend;
        this.cost += t.cost;
    }

    public void writeGpx(String filename) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.write(this.formatAsGpx());
        bw.close();
    }

    public String formatAsGpx() {
        StringBuilder sb = new StringBuilder(8192);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        int i = this.messageList.size() - 1;
        while (i >= 0) {
            String message = this.messageList.get(i);
            if (i < this.messageList.size() - 1) {
                message = "(alt-index " + i + ": " + message + " )";
            }
            if (message != null) {
                sb.append("<!-- " + message + " -->\n");
            }
            --i;
        }
        sb.append("<gpx \n");
        sb.append(" xmlns=\"http://www.topografix.com/GPX/1/1\" \n");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n");
        sb.append(" xsi:schemaLocation=\"http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd\" \n");
        sb.append(" creator=\"BRouter-0.97\" version=\"1.1\">\n");
        sb.append(" <trk>\n");
        sb.append("  <name>" + this.name + "</name>\n");
        sb.append("  <trkseg>\n");
        for (OsmPathElement n : this.nodes) {
            String sele = n.getSElev() == Short.MIN_VALUE ? "" : "<ele>" + n.getElev() + "</ele>";
            sb.append("   <trkpt lon=\"" + OsmTrack.formatPos(n.getILon() - 180000000) + "\" lat=\"" + OsmTrack.formatPos(n.getILat() - 90000000) + "\">" + sele + "</trkpt>\n");
        }
        sb.append("  </trkseg>\n");
        sb.append(" </trk>\n");
        sb.append("</gpx>\n");
        return sb.toString();
    }

    public void writeKml(String filename) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.write(this.formatAsKml());
        bw.close();
    }

    public String formatAsKml() {
        StringBuilder sb = new StringBuilder(8192);
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<kml xmlns=\"http://earth.google.com/kml/2.0\">\n");
        sb.append("  <Document>\n");
        sb.append("    <name>KML Samples</name>\n");
        sb.append("    <open>1</open>\n");
        sb.append("    <distance>3.497064</distance>\n");
        sb.append("    <traveltime>872</traveltime>\n");
        sb.append("    <description>To enable simple instructions add: 'instructions=1' as parameter to the URL</description>\n");
        sb.append("    <Folder>\n");
        sb.append("      <name>Paths</name>\n");
        sb.append("      <visibility>0</visibility>\n");
        sb.append("      <description>Examples of paths.</description>\n");
        sb.append("      <Placemark>\n");
        sb.append("        <name>Tessellated</name>\n");
        sb.append("        <visibility>0</visibility>\n");
        sb.append("        <description><![CDATA[If the <tessellate> tag has a value of 1, the line will contour to the underlying terrain]]></description>\n");
        sb.append("        <LineString>\n");
        sb.append("          <tessellate>1</tessellate>\n");
        sb.append("         <coordinates> ");
        for (OsmPathElement n : this.nodes) {
            sb.append(String.valueOf(OsmTrack.formatPos(n.getILon() - 180000000)) + "," + OsmTrack.formatPos(n.getILat() - 90000000) + "\n");
        }
        sb.append("          </coordinates>\n");
        sb.append("        </LineString>\n");
        sb.append("      </Placemark>\n");
        sb.append("    </Folder>\n");
        sb.append("  </Document>\n");
        sb.append("</kml>\n");
        return sb.toString();
    }

    private static String formatPos(int p) {
        boolean negative;
        boolean bl = negative = p < 0;
        if (negative) {
            p = -p;
        }
        char[] ac = new char[12];
        int i = 11;
        while (p != 0 || i > 3) {
            ac[i--] = (char)(48 + p % 10);
            p /= 10;
            if (i != 5) continue;
            ac[i--] = 46;
        }
        if (negative) {
            ac[i--] = 45;
        }
        return new String(ac, i + 1, 11 - i);
    }

    public void dumpMessages(String filename, RoutingContext rc) throws Exception {
        BufferedWriter bw = filename == null ? null : new BufferedWriter(new FileWriter(filename));
        String header = "Longitude\tLatitude\tElevation\tDistance\tCostPerKm\tElevCost\tTurnCost";
        if (rc.expctxWay != null) {
            header = String.valueOf(header) + rc.expctxWay.getCsvHeader();
        }
        this.dumpLine(bw, header);
        for (OsmPathElement n : this.nodes) {
            if (n.message == null) continue;
            this.dumpLine(bw, n.message);
        }
        if (bw != null) {
            bw.close();
        }
    }

    private void dumpLine(BufferedWriter bw, String s) throws Exception {
        if (bw == null) {
            System.out.println(s);
        } else {
            bw.write(s);
            bw.write("\n");
        }
    }

    public void readGpx(String filename) throws Exception {
        String line;
        File f = new File(filename);
        if (!f.exists()) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
        while ((line = br.readLine()) != null) {
            int idx0 = line.indexOf("<trkpt lon=\"");
            if (idx0 < 0) continue;
            int idx1 = line.indexOf(34, idx0 += 12);
            int ilon = (int)((Double.parseDouble(line.substring(idx0, idx1)) + 180.0) * 1000000.0 + 0.5);
            int idx2 = line.indexOf(" lat=\"");
            if (idx2 < 0) continue;
            int idx3 = line.indexOf(34, idx2 += 6);
            int ilat = (int)((Double.parseDouble(line.substring(idx2, idx3)) + 90.0) * 1000000.0 + 0.5);
            this.nodes.add(new OsmPathElement(ilon, ilat, 0, null));
        }
        br.close();
    }

    public boolean equalsTrack(OsmTrack t) {
        if (this.nodes.size() != t.nodes.size()) {
            return false;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            OsmPathElement e1 = this.nodes.get(i);
            OsmPathElement e2 = t.nodes.get(i);
            if (e1.getILon() != e2.getILon() || e1.getILat() != e2.getILat()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private class OsmPathElementHolder {
        public OsmPathElement node;
        public OsmPathElementHolder nextHolder;

        private OsmPathElementHolder() {
        }
    }
}

