/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.util.LongList;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class WayData
extends MapCreatorBase {
    public long wid;
    public long description;
    public LongList nodes;

    public WayData(long id) {
        this.wid = id;
        this.nodes = new LongList(16);
    }

    public WayData(long id, LongList nodes) {
        this.wid = id;
        this.nodes = nodes;
    }

    public WayData(DataInputStream di) throws Exception {
        long nid;
        this.nodes = new LongList(16);
        this.wid = WayData.readId(di);
        this.description = di.readLong();
        while ((nid = WayData.readId(di)) != -1L) {
            this.nodes.add(nid);
        }
    }

    public void writeTo(DataOutputStream dos) throws Exception {
        WayData.writeId(dos, this.wid);
        dos.writeLong(this.description);
        int size = this.nodes.size();
        int i = 0;
        while (i < size) {
            WayData.writeId(dos, this.nodes.get(i));
            ++i;
        }
        WayData.writeId(dos, -1L);
    }
}

