/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeListener;
import btools.mapcreator.RelationData;
import btools.mapcreator.RelationListener;
import btools.mapcreator.WayData;
import btools.mapcreator.WayListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;

public class OsmParser
extends MapCreatorBase {
    private BufferedReader _br;
    private NodeListener nListener;
    private WayListener wListener;
    private RelationListener rListener;

    public void readMap(File mapFile, NodeListener nListener, WayListener wListener, RelationListener rListener) throws Exception {
        String line;
        this.nListener = nListener;
        this.wListener = wListener;
        this.rListener = rListener;
        this._br = mapFile == null ? new BufferedReader(new InputStreamReader(System.in)) : (mapFile.getName().endsWith(".gz") ? new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(mapFile)))) : new BufferedReader(new InputStreamReader(new FileInputStream(mapFile))));
        while ((line = this._br.readLine()) != null) {
            if (this.checkNode(line) || this.checkWay(line) || this.checkRelation(line) || !this.checkChangeset(line)) continue;
        }
        if (mapFile != null) {
            this._br.close();
        }
    }

    private boolean checkNode(String line) throws Exception {
        int idx0 = line.indexOf("<node id=\"");
        if (idx0 < 0) {
            return false;
        }
        int idx1 = line.indexOf(34, idx0 += 10);
        long nodeId = Long.parseLong(line.substring(idx0, idx1));
        int idx2 = line.indexOf(" lat=\"");
        if (idx2 < 0) {
            return false;
        }
        int idx3 = line.indexOf(34, idx2 += 6);
        double lat = Double.parseDouble(line.substring(idx2, idx3));
        int idx4 = line.indexOf(" lon=\"");
        if (idx4 < 0) {
            return false;
        }
        int idx5 = line.indexOf(34, idx4 += 6);
        double lon = Double.parseDouble(line.substring(idx4, idx5));
        NodeData n = new NodeData(nodeId, lon, lat);
        if (!line.endsWith("/>")) {
            while (true) {
                String l2;
                if ((l2 = this._br.readLine()) == null) {
                    return false;
                }
                int i2 = l2.indexOf("<tag k=\"");
                if (i2 >= 0) {
                    int ri2 = l2.indexOf(34, i2 += 8);
                    String key = l2.substring(i2, ri2);
                    i2 = l2.indexOf(" v=\"", ri2);
                    if (i2 < 0) continue;
                    int ri3 = l2.indexOf(34, i2 += 4);
                    String value = l2.substring(i2, ri3);
                    n.putTag(key, value);
                    continue;
                }
                if (l2.indexOf("</node>") >= 0) break;
            }
        }
        this.nListener.nextNode(n);
        return true;
    }

    private boolean checkWay(String line) throws Exception {
        int idx0 = line.indexOf("<way id=\"");
        if (idx0 < 0) {
            return false;
        }
        int idx1 = line.indexOf(34, idx0 += 9);
        long id = Long.parseLong(line.substring(idx0, idx1));
        WayData w = new WayData(id);
        while (true) {
            int ri2;
            String l2;
            if ((l2 = this._br.readLine()) == null) {
                return false;
            }
            int i2 = l2.indexOf("<nd ref=\"");
            if (i2 >= 0) {
                ri2 = l2.indexOf(34, i2 += 9);
                long nid = Long.parseLong(l2.substring(i2, ri2));
                w.nodes.add(nid);
                continue;
            }
            i2 = l2.indexOf("<tag k=\"");
            if (i2 >= 0) {
                ri2 = l2.indexOf(34, i2 += 8);
                String key = l2.substring(i2, ri2);
                i2 = l2.indexOf(" v=\"", ri2);
                if (i2 < 0) continue;
                int ri3 = l2.indexOf(34, i2 += 4);
                String value = l2.substring(i2, ri3);
                w.putTag(key, value);
                continue;
            }
            if (l2.indexOf("</way>") >= 0) break;
        }
        this.wListener.nextWay(w);
        return true;
    }

    private boolean checkChangeset(String line) throws Exception {
        int idx0 = line.indexOf("<changeset id=\"");
        if (idx0 < 0) {
            return false;
        }
        if (!line.endsWith("/>")) {
            String l2;
            int loopcheck = 0;
            while ((l2 = this._br.readLine()).indexOf("</changeset>") < 0 && ++loopcheck <= 10000) {
            }
        }
        return true;
    }

    private boolean checkRelation(String line) throws Exception {
        int idx0 = line.indexOf("<relation id=\"");
        if (idx0 < 0) {
            return false;
        }
        int idx1 = line.indexOf(34, idx0 += 14);
        long rid = Long.parseLong(line.substring(idx0, idx1));
        RelationData r = new RelationData(rid);
        while (true) {
            int ri2;
            String l2;
            if ((l2 = this._br.readLine()) == null) {
                return false;
            }
            int i2 = l2.indexOf("<member type=\"way\" ref=\"");
            if (i2 >= 0) {
                ri2 = l2.indexOf(34, i2 += 24);
                long wid = Long.parseLong(l2.substring(i2, ri2));
                r.ways.add(wid);
                continue;
            }
            i2 = l2.indexOf("<tag k=\"");
            if (i2 >= 0) {
                ri2 = l2.indexOf(34, i2 += 8);
                String key = l2.substring(i2, ri2);
                i2 = l2.indexOf(" v=\"", ri2);
                if (i2 < 0) continue;
                int ri3 = l2.indexOf(34, i2 += 4);
                String value = l2.substring(i2, ri3);
                r.putTag(key, value);
                continue;
            }
            if (l2.indexOf("</relation>") >= 0) break;
        }
        this.rListener.nextRelation(r);
        return true;
    }
}

