/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;

public class NodeIterator
extends MapCreatorBase {
    private NodeListener listener;
    private boolean delete;

    public NodeIterator(NodeListener nodeListener, boolean deleteAfterReading) {
        this.listener = nodeListener;
        this.delete = deleteAfterReading;
    }

    public void processDir(File indir, String inSuffix) throws Exception {
        if (!indir.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + indir);
        }
        File[] af = NodeIterator.sortBySizeAsc(indir.listFiles());
        int i = 0;
        while (i < af.length) {
            File nodefile = af[i];
            if (nodefile.getName().endsWith(inSuffix)) {
                this.processFile(nodefile);
            }
            ++i;
        }
    }

    public void processFile(File nodefile) throws Exception {
        System.out.println("*** NodeIterator reading: " + nodefile);
        this.listener.nodeFileStart(nodefile);
        DataInputStream di = new DataInputStream(new BufferedInputStream(new FileInputStream(nodefile)));
        try {
            while (true) {
                NodeData n = new NodeData(di);
                this.listener.nextNode(n);
            }
        }
        catch (EOFException eof) {
            di.close();
            this.listener.nodeFileEnd(nodefile);
            if (this.delete && "true".equals(System.getProperty("deletetmpfiles"))) {
                nodefile.delete();
            }
            return;
        }
    }
}

