/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import btools.util.CompactLongMap;
import java.util.ArrayList;
import java.util.List;

public class FrozenLongMap<V>
extends CompactLongMap<V> {
    private long[] faid;
    private ArrayList<V> flv;
    private int size = 0;
    private int p2size;

    public FrozenLongMap(CompactLongMap<V> map) {
        this.size = map.size();
        this.faid = new long[this.size];
        this.flv = new ArrayList(this.size);
        map.moveToFrozenArrays(this.faid, this.flv);
        this.p2size = 0x40000000;
        while (this.p2size > this.size) {
            this.p2size >>= 1;
        }
    }

    @Override
    public boolean put(long id, V value) {
        throw new RuntimeException("cannot put on FrozenLongIntMap");
    }

    @Override
    public void fastPut(long id, V value) {
        throw new RuntimeException("cannot put on FrozenLongIntMap");
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    protected boolean contains(long id, boolean doPut) {
        if (this.size == 0) {
            return false;
        }
        long[] a = this.faid;
        int n = 0;
        for (int offset = this.p2size; offset > 0; offset >>= 1) {
            int nn = n + offset;
            if (nn >= this.size || a[nn] > id) continue;
            n = nn;
        }
        if (a[n] == id) {
            this.value_out = this.flv.get(n);
            return true;
        }
        return false;
    }

    @Override
    public V get(long id) {
        if (this.size == 0) {
            return null;
        }
        long[] a = this.faid;
        int n = 0;
        for (int offset = this.p2size; offset > 0; offset >>= 1) {
            int nn = n + offset;
            if (nn >= this.size || a[nn] > id) continue;
            n = nn;
        }
        if (a[n] == id) {
            return this.flv.get(n);
        }
        return null;
    }

    public List<V> getValueList() {
        return this.flv;
    }
}

