/*
 * Decompiled with CFR 0.152.
 */
package btools.server.request;

import btools.router.OsmNodeNamed;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.server.ServiceContext;
import btools.server.request.RequestHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ServerHandler
extends RequestHandler {
    public ServerHandler(ServiceContext serviceContext, HashMap<String, String> params) {
        super(serviceContext, params);
    }

    @Override
    public RoutingContext readRoutingContext() {
        RoutingContext rc = new RoutingContext();
        rc.localFunction = (String)this.params.get("profile");
        rc.setAlternativeIdx(Integer.parseInt((String)this.params.get("alternativeidx")));
        List<OsmNodeNamed> nogoList = this.readNogoList();
        if (nogoList != null) {
            rc.prepareNogoPoints(nogoList);
            rc.nogopoints = nogoList;
        }
        return rc;
    }

    @Override
    public List<OsmNodeNamed> readWayPointList() {
        String lonLats = (String)this.params.get("lonlats");
        if (lonLats == null) {
            throw new IllegalArgumentException("lonlats parameter not set");
        }
        String[] coords = lonLats.split("\\|");
        if (coords.length < 2) {
            throw new IllegalArgumentException("we need two lat/lon points at least!");
        }
        ArrayList<OsmNodeNamed> wplist = new ArrayList<OsmNodeNamed>();
        for (int i = 0; i < coords.length; ++i) {
            String[] lonLat = coords[i].split(",");
            wplist.add(ServerHandler.readPosition(lonLat[0], lonLat[1], "via" + i));
        }
        ((OsmNodeNamed)wplist.get((int)0)).name = "from";
        ((OsmNodeNamed)wplist.get((int)(wplist.size() - 1))).name = "to";
        return wplist;
    }

    @Override
    public String formatTrack(OsmTrack track) {
        String result;
        String format = (String)this.params.get("format");
        if (format == null || "gpx".equals(format)) {
            result = track.formatAsGpx();
        } else if ("kml".equals(format)) {
            result = track.formatAsKml();
        } else {
            System.out.println("unknown track format '" + format + "', using default");
            result = track.formatAsGpx();
        }
        return result;
    }

    private static OsmNodeNamed readPosition(String vlon, String vlat, String name) {
        if (vlon == null) {
            throw new IllegalArgumentException("lon " + name + " not found in input");
        }
        if (vlat == null) {
            throw new IllegalArgumentException("lat " + name + " not found in input");
        }
        return ServerHandler.readPosition(Double.parseDouble(vlon), Double.parseDouble(vlat), name);
    }

    private static OsmNodeNamed readPosition(double lon, double lat, String name) {
        OsmNodeNamed n = new OsmNodeNamed();
        n.name = name;
        n.ilon = (int)((lon + 180.0) * 1000000.0 + 0.5);
        n.ilat = (int)((lat + 90.0) * 1000000.0 + 0.5);
        return n;
    }

    private List<OsmNodeNamed> readNogoList() {
        String nogos = (String)this.params.get("nogos");
        if (nogos == null) {
            return null;
        }
        String[] lonLatRadList = nogos.split("\\|");
        ArrayList<OsmNodeNamed> nogoList = new ArrayList<OsmNodeNamed>();
        for (int i = 0; i < lonLatRadList.length; ++i) {
            String[] lonLatRad = lonLatRadList[i].split(",");
            nogoList.add(ServerHandler.readNogo(lonLatRad[0], lonLatRad[1], lonLatRad[2]));
        }
        return nogoList;
    }

    private static OsmNodeNamed readNogo(String lon, String lat, String radius) {
        return ServerHandler.readNogo(Double.parseDouble(lon), Double.parseDouble(lat), Integer.parseInt(radius));
    }

    private static OsmNodeNamed readNogo(double lon, double lat, int radius) {
        OsmNodeNamed n = new OsmNodeNamed();
        n.name = "nogo" + radius;
        n.ilon = (int)((lon + 180.0) * 1000000.0 + 0.5);
        n.ilat = (int)((lat + 90.0) * 1000000.0 + 0.5);
        n.isNogo = true;
        return n;
    }
}

