/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.router.OsmNodeNamed;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import btools.server.ServiceContext;
import btools.server.request.RequestHandler;
import btools.server.request.ServerHandler;
import btools.server.request.YoursHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class RouteServer
extends Thread {
    public ServiceContext serviceContext;
    public short port = (short)17777;
    private boolean serverStopped = false;
    private ServerSocket serverSocket = null;

    public void close() {
        this.serverStopped = true;
        try {
            ServerSocket ss = this.serverSocket;
            this.serverSocket = null;
            ss.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killOtherServer() throws Exception {
        Socket socket = new Socket("localhost", (int)this.port);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            bw.write("EXIT\n");
        }
        finally {
            bw.close();
            socket.close();
        }
    }

    @Override
    public void run() {
        block8: while (true) {
            try {
                while (true) {
                    this.killOtherServer();
                    System.out.println("killed, waiting");
                    try {
                        Thread.sleep(3000L);
                        continue block8;
                    }
                    catch (InterruptedException ie) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable t) {
                System.out.println("not killed: " + t);
                try {
                    Socket clientSocket;
                    this.serverSocket = new ServerSocket(this.port);
                    do {
                        System.out.println("RouteServer accepting connections..");
                    } while (this.serveRequest(clientSocket = this.serverSocket.accept()));
                }
                catch (Throwable e) {
                    System.out.println("RouteServer main loop got exception (exiting): " + e);
                    if (this.serverSocket != null) {
                        try {
                            this.serverSocket.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    System.exit(0);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean serveRequest(Socket clientSocket) {
        block39: {
            BufferedWriter bw;
            BufferedReader br;
            block38: {
                String getline;
                block36: {
                    boolean bl;
                    block37: {
                        br = null;
                        bw = null;
                        br = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                        bw = new BufferedWriter(new OutputStreamWriter(clientSocket.getOutputStream()));
                        getline = br.readLine();
                        if (getline == null || getline.startsWith("EXIT")) {
                            throw new RuntimeException("socketExitRequest");
                        }
                        if (!getline.startsWith("GET /favicon.ico")) break block36;
                        bl = true;
                        if (br == null) break block37;
                        try {
                            br.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    return bl;
                }
                String url = getline.split(" ")[1];
                HashMap<String, String> params = RouteServer.getUrlParams(url);
                long maxRunningTime = RouteServer.getMaxRunningTime();
                long startTime = System.currentTimeMillis();
                RequestHandler handler = params.containsKey("lonlats") && params.containsKey("profile") ? new ServerHandler(this.serviceContext, params) : new YoursHandler(this.serviceContext, params);
                RoutingContext rc = handler.readRoutingContext();
                List<OsmNodeNamed> wplist = handler.readWayPointList();
                RoutingEngine cr = new RoutingEngine(null, null, this.serviceContext.segmentDir, wplist, rc);
                cr.quite = true;
                cr.doRun(maxRunningTime);
                bw.write("HTTP/1.1 200 OK\n");
                bw.write("Connection: close\n");
                bw.write("Content-Type: text/xml; charset=utf-8\n");
                bw.write("Access-Control-Allow-Origin: *\n");
                bw.write("\n");
                if (cr.getErrorMessage() != null) {
                    bw.write(cr.getErrorMessage());
                    bw.write("\n");
                } else {
                    OsmTrack track = cr.getFoundTrack();
                    if (track != null) {
                        bw.write(handler.formatTrack(track));
                    }
                }
                bw.flush();
                if (br == null) break block38;
                try {
                    br.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {}
            }
            break block39;
            catch (Throwable e) {
                if ("socketExitRequest".equals(e.getMessage())) {
                    boolean bl = false;
                    return bl;
                }
                System.out.println("RouteServer got exception (will continue): " + e);
                e.printStackTrace();
                break block39;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            {
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Exception e2) {}
                    }
                    if (bw != null) {
                        try {
                            bw.close();
                        }
                        catch (Exception e3) {}
                    }
                }
            }
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("BRouter 0.96 / 27102013 / abrensch");
        if (args.length != 3) {
            System.out.println("serve YOURS protocol for BRouter");
            System.out.println("usage: java RouteServer <segmentdir> <profile-list> <port>");
            System.out.println("");
            System.out.println("serve BRouter protocol");
            System.out.println("usage: java RouteServer <segmentdir> <profiledir> <port>");
            return;
        }
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.segmentDir = args[0];
        File profileMapOrDir = new File(args[1]);
        if (profileMapOrDir.isDirectory()) {
            System.setProperty("profileBaseDir", args[1]);
        } else {
            serviceContext.profileMap = RouteServer.loadProfileMap(profileMapOrDir);
        }
        ServerSocket serverSocket = new ServerSocket(Integer.parseInt(args[2]));
        while (true) {
            Socket clientSocket = serverSocket.accept();
            RouteServer server = new RouteServer();
            server.serviceContext = serviceContext;
            server.serveRequest(clientSocket);
        }
    }

    private static Map<String, String> loadProfileMap(File file) throws IOException {
        String key;
        HashMap<String, String> profileMap = new HashMap<String, String>();
        BufferedReader pr = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        while ((key = pr.readLine()) != null) {
            if ((key = key.trim()).length() == 0) continue;
            String value = pr.readLine();
            value = value.trim();
            profileMap.put(key, value);
        }
        return profileMap;
    }

    private static HashMap<String, String> getUrlParams(String url) {
        HashMap<String, String> params = new HashMap<String, String>();
        StringTokenizer tk = new StringTokenizer(url, "?&");
        while (tk.hasMoreTokens()) {
            String t = tk.nextToken();
            StringTokenizer tk2 = new StringTokenizer(t, "=");
            if (!tk2.hasMoreTokens()) continue;
            String key = tk2.nextToken();
            if (!tk2.hasMoreTokens()) continue;
            String value = tk2.nextToken();
            params.put(key, value);
        }
        return params;
    }

    private static long getMaxRunningTime() {
        long maxRunningTime = 60000L;
        String sMaxRunningTime = System.getProperty("maxRunningTime");
        if (sMaxRunningTime != null) {
            maxRunningTime = Integer.parseInt(sMaxRunningTime) * 1000;
        }
        return maxRunningTime;
    }
}

