/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.WayData;
import btools.mapcreator.WayIterator;
import btools.util.CompactLongSet;
import btools.util.DenseLongMap;
import btools.util.TinyDenseLongMap;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;

public class WayCutter
extends MapCreatorBase {
    private CompactLongSet cyclewayset;
    private DenseLongMap tileIndexMap;

    public static void main(String[] args) throws Exception {
        System.out.println("*** WayCutter: Soft-Cut way-data into tiles");
        if (args.length != 4) {
            System.out.println("usage: java WayCutter <node-tiles-in> <way-file-in> <way-tiles-out> <relation-file>");
            return;
        }
        new WayCutter().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]));
    }

    public void process(File nodeTilesIn, File wayFileIn, File wayTilesOut, File relationFileIn) throws Exception {
        this.outTileDir = wayTilesOut;
        this.cyclewayset = new CompactLongSet();
        DataInputStream dis = this.createInStream(relationFileIn);
        try {
            while (true) {
                long wid;
                if (this.cyclewayset.contains(wid = WayCutter.readId(dis))) {
                    continue;
                }
                this.cyclewayset.add(wid);
            }
        }
        catch (EOFException eof) {
            dis.close();
            System.out.println("marked cycleways: " + this.cyclewayset.size());
            this.tileIndexMap = Boolean.getBoolean("useDenseMaps") ? new DenseLongMap(6) : new TinyDenseLongMap();
            new NodeIterator(this, false).processDir(nodeTilesIn, ".tlf");
            new WayIterator(this, true).processFile(wayFileIn);
            this.closeTileOutStreams();
            return;
        }
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        this.tileIndexMap.put(n.nid, this.getTileIndex(n.ilon, n.ilat));
    }

    @Override
    public void nextWay(WayData data) throws Exception {
        if (this.cyclewayset.contains(data.wid)) {
            data.description |= 2L;
        }
        long waytileset = 0L;
        int nnodes = data.nodes.size();
        for (int i = 0; i < nnodes; ++i) {
            int tileIndex = this.tileIndexMap.getInt(data.nodes.get(i));
            if (tileIndex == -1) continue;
            waytileset |= 1L << tileIndex;
        }
        for (int tileIndex = 0; tileIndex < 54; ++tileIndex) {
            if ((waytileset & 1L << tileIndex) == 0L) continue;
            data.writeTo(this.getOutStreamForTile(tileIndex));
        }
    }

    private int getTileIndex(int ilon, int ilat) {
        int lon = ilon / 45000000;
        int lat = ilat / 30000000;
        if (lon < 0 || lon > 7 || lat < 0 || lat > 5) {
            throw new IllegalArgumentException("illegal pos: " + ilon + "," + ilat);
        }
        return lon * 6 + lat;
    }

    @Override
    protected String getNameForTile(int tileIndex) {
        int lon = tileIndex / 6 * 45 - 180;
        int lat = tileIndex % 6 * 30 - 90;
        String slon = lon < 0 ? "W" + -lon : "E" + lon;
        String slat = lat < 0 ? "S" + -lat : "N" + lat;
        return slon + "_" + slat + ".wtl";
    }
}

