/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import btools.mapcreator.NodeData;
import btools.mapcreator.NodeIterator;
import btools.mapcreator.SrtmData;
import btools.util.CompactLongSet;
import btools.util.FrozenLongSet;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.util.HashMap;

public class PosUnifier
extends MapCreatorBase {
    private DataOutputStream nodesOutStream;
    private DataOutputStream borderNodesOut;
    private File nodeTilesOut;
    private CompactLongSet positionSet;
    private HashMap<String, SrtmData> srtmmap;
    private int lastStrmLonIdx;
    private int lastStrmLatIdx;
    private SrtmData lastSrtmData;
    private String srtmdir;
    private int totalLatSteps = 0;
    private int totalLonSteps = 0;
    private CompactLongSet borderNids;

    public static void main(String[] args) throws Exception {
        System.out.println("*** PosUnifier: Unify position values and enhance elevation");
        if (args.length != 5) {
            System.out.println("usage: java PosUnifier <node-tiles-in> <node-tiles-out> <bordernids-in> <bordernodes-out> <strm-data-dir>");
            return;
        }
        new PosUnifier().process(new File(args[0]), new File(args[1]), new File(args[2]), new File(args[3]), args[4]);
    }

    public void process(File nodeTilesIn, File nodeTilesOut, File bordernidsinfile, File bordernodesoutfile, String srtmdir) throws Exception {
        this.nodeTilesOut = nodeTilesOut;
        this.srtmdir = srtmdir;
        DataInputStream dis = this.createInStream(bordernidsinfile);
        this.borderNids = new CompactLongSet();
        try {
            while (true) {
                long nid;
                if (this.borderNids.contains(nid = PosUnifier.readId(dis))) {
                    continue;
                }
                this.borderNids.fastAdd(nid);
            }
        }
        catch (EOFException eof) {
            dis.close();
            this.borderNids = new FrozenLongSet(this.borderNids);
            this.borderNodesOut = this.createOutStream(bordernodesoutfile);
            new NodeIterator(this, true).processDir(nodeTilesIn, ".n5d");
            this.borderNodesOut.close();
            return;
        }
    }

    @Override
    public void nodeFileStart(File nodefile) throws Exception {
        this.resetSrtm();
        this.nodesOutStream = this.createOutStream(this.fileFromTemplate(nodefile, this.nodeTilesOut, "u5d"));
        this.positionSet = new CompactLongSet();
    }

    @Override
    public void nextNode(NodeData n) throws Exception {
        SrtmData srtm = this.srtmForNode(n.ilon, n.ilat);
        n.selev = (short)(srtm == null ? Short.MIN_VALUE : (int)srtm.getElevation(n.ilon, n.ilat));
        this.findUniquePos(n);
        n.writeTo(this.nodesOutStream);
        if (this.borderNids.contains(n.nid)) {
            n.writeTo(this.borderNodesOut);
        }
    }

    @Override
    public void nodeFileEnd(File nodeFile) throws Exception {
        this.nodesOutStream.close();
    }

    private void findUniquePos(NodeData n) {
        int lonmod = n.ilon % 1000000;
        int londelta = lonmod < 500000 ? 1 : -1;
        int latmod = n.ilat % 1000000;
        int latdelta = latmod < 500000 ? 1 : -1;
        for (int latsteps = 0; latsteps < 100; ++latsteps) {
            for (int lonsteps = 0; lonsteps <= latsteps; ++lonsteps) {
                int lon = n.ilon + lonsteps * londelta;
                int lat = n.ilat + latsteps * latdelta;
                long pid = (long)lon << 32 | (long)lat;
                if (this.positionSet.contains(pid)) continue;
                this.totalLonSteps += lonsteps;
                this.totalLatSteps += latsteps;
                this.positionSet.fastAdd(pid);
                n.ilon = lon;
                n.ilat = lat;
                return;
            }
        }
        System.out.println("*** WARNING: cannot unify position for: " + n.ilon + " " + n.ilat);
    }

    private SrtmData srtmForNode(int ilon, int ilat) throws Exception {
        int srtmLonIdx = (ilon + 5000000) / 5000000;
        int srtmLatIdx = (154999999 - ilat) / 5000000;
        if (srtmLatIdx < 1 || srtmLatIdx > 24 || srtmLonIdx < 1 || srtmLonIdx > 72) {
            return null;
        }
        if (srtmLonIdx == this.lastStrmLonIdx && srtmLatIdx == this.lastStrmLatIdx) {
            return this.lastSrtmData;
        }
        this.lastStrmLonIdx = srtmLonIdx;
        this.lastStrmLatIdx = srtmLatIdx;
        StringBuilder sb = new StringBuilder(16);
        sb.append("srtm_");
        sb.append((char)(48 + srtmLonIdx / 10)).append((char)(48 + srtmLonIdx % 10)).append('_');
        sb.append((char)(48 + srtmLatIdx / 10)).append((char)(48 + srtmLatIdx % 10)).append(".zip");
        String filename = sb.toString();
        this.lastSrtmData = this.srtmmap.get(filename);
        if (this.lastSrtmData == null && !this.srtmmap.containsKey(filename)) {
            File f = new File(new File(this.srtmdir), filename);
            System.out.println("reading: " + f + " ilon=" + ilon + " ilat=" + ilat);
            if (f.exists()) {
                try {
                    this.lastSrtmData = new SrtmData(f);
                }
                catch (Exception e) {
                    System.out.println("**** ERROR reading " + f + " ****");
                }
            }
            this.srtmmap.put(filename, this.lastSrtmData);
        }
        return this.lastSrtmData;
    }

    private void resetSrtm() {
        this.srtmmap = new HashMap();
        this.lastStrmLonIdx = -1;
        this.lastStrmLatIdx = -1;
        this.lastSrtmData = null;
    }
}

