/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.OsmLinkP;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class OsmNodeP
implements Comparable<OsmNodeP> {
    public static final int EXTERNAL_BITMASK = 128;
    public static final int FIRSTFORWAY_BITMASK = 64;
    public static final int TRANSFERNODE_BITMASK = 32;
    public static final int WRITEDESC_BITMASK = 16;
    public static final int SKIPDETAILS_BITMASK = 8;
    public static final int NODEDESC_BITMASK = 4;
    public int ilat;
    public int ilon;
    public OsmLinkP firstlink = null;
    public short selev;
    public boolean isBorder = false;
    public byte wayAndBits = (byte)-1;

    public int getILat() {
        return this.ilat;
    }

    public int getILon() {
        return this.ilon;
    }

    public short getSElev() {
        return (this.wayAndBits & 0x18) == 0 ? (short)this.selev : (short)Short.MIN_VALUE;
    }

    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public void addLink(OsmLinkP link) {
        if (this.firstlink != null) {
            link.next = this.firstlink;
        }
        this.firstlink = link;
    }

    public long getNodeDecsription() {
        return 0L;
    }

    public void writeNodeData(DataOutputStream os) throws IOException {
        int lonIdx = this.ilon / 62500;
        int latIdx = this.ilat / 62500;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream os2 = new DataOutputStream(bos);
        os2.writeShort(this.getSElev());
        int nlinks = 0;
        long nodeDescription = this.getNodeDecsription();
        OsmLinkP link0 = this.firstlink;
        while (link0 != null) {
            OsmNodeP target;
            int skipDetailBit;
            ++nlinks;
            OsmLinkP link = link0;
            OsmNodeP origin = this;
            int n = skipDetailBit = link0.counterLinkWritten() ? 8 : 0;
            while (link != null && (target = link.targetNode).isTransferNode()) {
                link = target.firstlink;
                while (link != null && link.targetNode == origin) {
                    link = link.next;
                }
                origin = target;
            }
            if (link != null) {
                if (skipDetailBit == 0) {
                    link = link0;
                }
                origin = this;
                long lastDescription = 0L;
                while (link != null) {
                    int nodedescbit;
                    OsmNodeP target2 = link.targetNode;
                    int tranferbit = target2.isTransferNode() ? 32 : 0;
                    int writedescbit = link.descriptionBitmap != lastDescription ? 16 : 0;
                    int n2 = nodedescbit = nodeDescription != 0L ? 4 : 0;
                    if (skipDetailBit != 0) {
                        writedescbit = 0;
                    }
                    int targetLonIdx = target2.ilon / 62500;
                    int targetLatIdx = target2.ilat / 62500;
                    if (targetLonIdx == lonIdx && targetLatIdx == latIdx) {
                        os2.writeByte(tranferbit | writedescbit | nodedescbit | skipDetailBit);
                        os2.writeShort((short)(target2.ilon - lonIdx * 62500 - 31250));
                        os2.writeShort((short)(target2.ilat - latIdx * 62500 - 31250));
                    } else {
                        os2.writeByte(tranferbit | writedescbit | nodedescbit | skipDetailBit | 0x80);
                        os2.writeInt(target2.ilon);
                        os2.writeInt(target2.ilat);
                    }
                    if (writedescbit != 0) {
                        os2.writeLong(link.descriptionBitmap);
                    }
                    if (nodedescbit != 0) {
                        os2.writeLong(nodeDescription);
                        nodeDescription = 0L;
                    }
                    lastDescription = link.descriptionBitmap;
                    if (tranferbit == 0) {
                        target2.markLinkWritten(origin);
                        break;
                    }
                    os2.writeShort(target2.getSElev());
                    link = target2.firstlink;
                    while (link != null && link.targetNode == origin) {
                        link = link.next;
                    }
                    if (link == null) {
                        throw new RuntimeException("follow-up link not found for transfer-node!");
                    }
                    origin = target2;
                }
            }
            link0 = link0.next;
        }
        int bodySize = bos.size();
        os.writeShort((short)(this.ilon - lonIdx * 62500 - 31250));
        os.writeShort((short)(this.ilat - latIdx * 62500 - 31250));
        os.writeInt(bodySize);
        bos.writeTo(os);
    }

    public String toString2() {
        return this.ilon - 180000000 + "_" + (this.ilat - 90000000) + "_" + this.selev / 4;
    }

    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public boolean isTransferNode() {
        return !this.isBorder && this._linkCnt() == 2;
    }

    private int _linkCnt() {
        int cnt = 0;
        OsmLinkP link = this.firstlink;
        while (link != null) {
            ++cnt;
            link = link.next;
        }
        return cnt;
    }

    public void markLinkWritten(OsmNodeP t) {
        OsmLinkP link = this.firstlink;
        while (link != null) {
            if (link.targetNode == t) {
                link.descriptionBitmap = 0L;
            }
            link = link.next;
        }
    }

    @Override
    public int compareTo(OsmNodeP n) {
        long id2;
        long id1 = this.getIdFromPos();
        if (id1 < (id2 = n.getIdFromPos())) {
            return -1;
        }
        if (id1 > id2) {
            return 1;
        }
        return 0;
    }
}

