/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import btools.mapcreator.MapCreatorBase;
import java.io.DataInputStream;
import java.io.DataOutputStream;

public class NodeData
extends MapCreatorBase {
    public long nid;
    public int ilon;
    public int ilat;
    public long description;
    public short selev = Short.MIN_VALUE;

    public NodeData(long id, double lon, double lat) {
        this.nid = id;
        this.ilat = (int)((lat + 90.0) * 1000000.0 + 0.5);
        this.ilon = (int)((lon + 180.0) * 1000000.0 + 0.5);
    }

    public NodeData(DataInputStream dis) throws Exception {
        this.nid = NodeData.readId(dis);
        this.ilon = dis.readInt();
        this.ilat = dis.readInt();
        byte mode = dis.readByte();
        if ((mode & 1) != 0) {
            this.description = dis.readLong();
        }
        if ((mode & 2) != 0) {
            this.selev = dis.readShort();
        }
    }

    public void writeTo(DataOutputStream dos) throws Exception {
        NodeData.writeId(dos, this.nid);
        dos.writeInt(this.ilon);
        dos.writeInt(this.ilat);
        int mode = (this.description == 0L ? 0 : 1) | (this.selev == Short.MIN_VALUE ? 0 : 2);
        dos.writeByte((byte)mode);
        if ((mode & 1) != 0) {
            dos.writeLong(this.description);
        }
        if ((mode & 2) != 0) {
            dos.writeShort(this.selev);
        }
    }
}

