/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.DistanceChecker;
import btools.mapaccess.MicroCache;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNodesMap;
import btools.mapaccess.OsmPos;
import btools.mapaccess.OsmTransferNode;

public class OsmNode
implements OsmPos,
Comparable {
    private static final long serialVersionUID = -4166565134085275556L;
    public static final int EXTERNAL_BITMASK = 128;
    public static final int FIRSTFORWAY_BITMASK = 64;
    public static final int TRANSFERNODE_BITMASK = 32;
    public static final int WRITEDESC_BITMASK = 16;
    public static final int SKIPDETAILS_BITMASK = 8;
    public static final int NODEDESC_BITMASK = 4;
    public int ilat;
    public int ilon;
    public short selev;
    public long nodeDescription;
    public OsmLink firstlink = null;
    public OsmLink firstreverse = null;
    public boolean completed;
    public boolean wasProcessed;
    public int maxcost;

    public OsmNode() {
    }

    public OsmNode(int ilon, int ilat) {
        this.ilon = ilon;
        this.ilat = ilat;
    }

    public OsmNode(long id) {
        this.ilon = (int)(id >> 32);
        this.ilat = (int)(id & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public int getILat() {
        return this.ilat;
    }

    @Override
    public int getILon() {
        return this.ilon;
    }

    @Override
    public short getSElev() {
        return this.selev;
    }

    @Override
    public double getElev() {
        return (double)this.selev / 4.0;
    }

    public void addLink(OsmLink link) {
        if (this.firstlink != null) {
            link.next = this.firstlink;
        }
        this.firstlink = link;
    }

    @Override
    public int calcDistance(OsmPos p) {
        double l = (double)(this.ilat - 90000000) * 1.234134E-8;
        double l2 = l * l;
        double l4 = l2 * l2;
        double coslat = 1.0 - l2 + l4 / 6.0;
        double dlat = (double)(this.ilat - p.getILat()) / 1000000.0;
        double dlon = (double)(this.ilon - p.getILon()) / 1000000.0 * coslat;
        double d = Math.sqrt(dlat * dlat + dlon * dlon) * 111308.90052356021;
        return (int)(d + 1.0);
    }

    public void parseNodeBody(MicroCache is, int bodySize, OsmNodesMap hollowNodes, DistanceChecker dc) {
        this.selev = is.readShort();
        bodySize -= 2;
        OsmLink lastlink = null;
        int lonIdx = this.ilon / 62500;
        int latIdx = this.ilat / 62500;
        while (bodySize > 0) {
            int linklat;
            int linklon;
            OsmLink link = new OsmLink();
            OsmTransferNode firstTransferNode = null;
            OsmTransferNode lastTransferNode = null;
            long description = 0L;
            while (true) {
                boolean isTransfer;
                byte bitField = is.readByte();
                --bodySize;
                if ((bitField & 0x80) != 0) {
                    bodySize -= 8;
                    linklon = is.readInt();
                    linklat = is.readInt();
                } else {
                    bodySize -= 4;
                    linklon = is.readShort();
                    linklat = is.readShort();
                    linklon += lonIdx * 62500 + 31250;
                    linklat += latIdx * 62500 + 31250;
                }
                if ((bitField & 0x10) != 0) {
                    description = is.readLong();
                    bodySize -= 8;
                }
                if ((bitField & 4) != 0) {
                    this.nodeDescription = is.readLong();
                    bodySize -= 8;
                }
                if ((bitField & 8) != 0) {
                    link.counterLinkWritten = true;
                }
                boolean bl = isTransfer = (bitField & 0x20) != 0;
                if (!isTransfer) break;
                OsmTransferNode trans = new OsmTransferNode();
                trans.ilon = linklon;
                trans.ilat = linklat;
                trans.descriptionBitmap = description;
                bodySize -= 2;
                trans.selev = is.readShort();
                if (lastTransferNode == null) {
                    firstTransferNode = trans;
                } else {
                    lastTransferNode.next = trans;
                }
                lastTransferNode = trans;
            }
            link.descriptionBitmap = description;
            if (dc != null && !link.counterLinkWritten && !dc.isWithinRadius(this.ilon, this.ilat, firstTransferNode, linklon, linklat) || linklon == this.ilon && linklat == this.ilat) continue;
            if (lastlink == null) {
                this.firstlink = link;
            } else {
                lastlink.next = link;
            }
            lastlink = link;
            long targetNodeId = (long)linklon << 32 | (long)linklat;
            OsmNode tn = hollowNodes.get(targetNodeId);
            if (tn == null) {
                tn = new OsmNode(linklon, linklat);
                tn.setHollow();
                hollowNodes.put(targetNodeId, tn);
            } else if (!tn.isHollow() && !tn.hasHollowLinks()) {
                hollowNodes.registerCompletedNode(tn);
            }
            link.targetNode = tn;
            link.encodeFirsttransfer(firstTransferNode);
            if (link.counterLinkWritten) continue;
            OsmLink rlink = new OsmLink();
            long rerverseLinkBitmap = link.descriptionBitmap ^ 1L;
            rlink.ilonOrigin = tn.ilon;
            rlink.ilatOrigin = tn.ilat;
            rlink.targetNode = this;
            rlink.descriptionBitmap = rerverseLinkBitmap;
            OsmTransferNode previous = null;
            OsmTransferNode rtrans = null;
            OsmTransferNode trans = firstTransferNode;
            while (trans != null) {
                long rerverseTransBitmap = trans.descriptionBitmap ^ 1L;
                if (previous == null) {
                    rlink.descriptionBitmap = rerverseTransBitmap;
                } else {
                    previous.descriptionBitmap = rerverseTransBitmap;
                }
                rtrans = new OsmTransferNode();
                rtrans.ilon = trans.ilon;
                rtrans.ilat = trans.ilat;
                rtrans.selev = trans.selev;
                rtrans.next = previous;
                rtrans.descriptionBitmap = rerverseLinkBitmap;
                previous = rtrans;
                trans = trans.next;
            }
            rlink.encodeFirsttransfer(rtrans);
            rlink.next = this.firstreverse;
            this.firstreverse = rlink;
        }
        if (!this.hasHollowLinks()) {
            hollowNodes.registerCompletedNode(this);
        }
    }

    public boolean isHollow() {
        return this.selev == -12345;
    }

    public void setHollow() {
        this.selev = (short)-12345;
    }

    @Override
    public long getIdFromPos() {
        return (long)this.ilon << 32 | (long)this.ilat;
    }

    public boolean hasHollowLinks() {
        OsmLink link = this.firstlink;
        while (link != null) {
            if (link.targetNode.isHollow()) {
                return true;
            }
            link = link.next;
        }
        return false;
    }

    public int linkCnt() {
        int cnt = 0;
        OsmLink link = this.firstlink;
        while (link != null) {
            ++cnt;
            link = link.next;
        }
        return cnt;
    }

    public void unlinkLink(OsmLink link) {
        if (link == this.firstlink) {
            this.firstlink = link.next;
            return;
        }
        OsmLink l = this.firstlink;
        while (l != null) {
            if (l.next == link) {
                l.next = link.next;
                return;
            }
            l = l.next;
        }
    }

    public int compareTo(Object o) {
        long id2;
        OsmNode n = (OsmNode)o;
        long id1 = this.getIdFromPos();
        if (id1 < (id2 = n.getIdFromPos())) {
            return -1;
        }
        if (id1 > id2) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public void markLinkWritten(OsmNode t) {
        OsmLink link = this.firstlink;
        while (link != null) {
            if (link.targetNode == t) {
                link.counterLinkWritten = true;
            }
            link = link.next;
        }
    }

    public OsmLink getReverseLink(int lon, int lat) {
        OsmLink rlink = this.firstreverse;
        while (rlink != null) {
            if (rlink.ilonOrigin == lon && rlink.ilatOrigin == lat) {
                this.unlinkRLink(rlink);
                return rlink;
            }
            rlink = rlink.next;
        }
        return null;
    }

    public void unlinkRLink(OsmLink rlink) {
        if (rlink == this.firstreverse) {
            this.firstreverse = rlink.next;
            return;
        }
        OsmLink l = this.firstreverse;
        while (l != null) {
            if (l.next == rlink) {
                l.next = rlink.next;
                return;
            }
            l = l.next;
        }
    }
}

