/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.ByteDataReader;
import btools.mapaccess.MicroCache;
import java.io.IOException;
import java.io.RandomAccessFile;

final class OsmFile {
    private RandomAccessFile is = null;
    private long fileOffset;
    private int[] posIdx;
    public MicroCache[] microCaches;
    public int lonDegree;
    public int latDegree;
    public String filename;

    public OsmFile(RandomAccessFile rafile, long startPos, byte[] iobuffer) throws Exception {
        this.fileOffset = startPos;
        if (rafile != null) {
            this.is = rafile;
            this.posIdx = new int[6400];
            this.microCaches = new MicroCache[6400];
            this.is.seek(this.fileOffset);
            this.is.readFully(iobuffer, 0, 25600);
            ByteDataReader dis = new ByteDataReader(iobuffer);
            for (int i = 0; i < 6400; ++i) {
                this.posIdx[i] = dis.readInt();
            }
        }
    }

    private int getPosIdx(int idx) {
        return idx == -1 ? 25600 : this.posIdx[idx];
    }

    public int getDataInputForSubIdx(int subIdx, byte[] iobuffer) throws Exception {
        int startPos = this.getPosIdx(subIdx - 1);
        int endPos = this.getPosIdx(subIdx);
        int size = endPos - startPos;
        if (size > 0) {
            this.is.seek(this.fileOffset + (long)startPos);
            if (size <= iobuffer.length) {
                this.is.readFully(iobuffer);
            }
        }
        return size;
    }

    public void close() {
        try {
            this.is.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

