/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.ByteDataReader;
import btools.mapaccess.DistanceChecker;
import btools.mapaccess.MicroCache;
import btools.mapaccess.OsmFile;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class NodesCache {
    private String segmentDir;
    private OsmNodesMap nodesMap;
    private int lookupVersion;
    private boolean carMode;
    private String currentFileName;
    private HashMap<String, RandomAccessFile> fileCache;
    private HashMap<String, long[]> indexCache;
    private byte[] iobuffer;
    private OsmFile[][] fileRows = new OsmFile[180][];
    private ArrayList<MicroCache> segmentList = new ArrayList();
    public DistanceChecker distanceChecker;

    public NodesCache(String segmentDir, OsmNodesMap nodesMap, int lookupVersion, boolean carMode, NodesCache oldCache) {
        this.segmentDir = segmentDir;
        this.nodesMap = nodesMap;
        this.lookupVersion = lookupVersion;
        this.carMode = carMode;
        if (oldCache != null) {
            this.fileCache = oldCache.fileCache;
            this.indexCache = oldCache.indexCache;
            this.iobuffer = oldCache.iobuffer;
        } else {
            this.fileCache = new HashMap(4);
            this.indexCache = new HashMap(4);
            this.iobuffer = new byte[65636];
        }
    }

    public MicroCache getSegmentFor(int ilon, int ilat) {
        try {
            int lonIdx80 = ilon / 12500;
            int latIdx80 = ilat / 12500;
            int lonDegree = lonIdx80 / 80;
            int latDegree = latIdx80 / 80;
            OsmFile osmf = null;
            OsmFile[] fileRow = this.fileRows[latDegree];
            int ndegrees = fileRow == null ? 0 : fileRow.length;
            for (int i = 0; i < ndegrees; ++i) {
                if (fileRow[i].lonDegree != lonDegree) continue;
                osmf = fileRow[i];
                break;
            }
            if (osmf == null) {
                osmf = this.fileForSegment(lonDegree, latDegree);
                OsmFile[] newFileRow = new OsmFile[ndegrees + 1];
                for (int i = 0; i < ndegrees; ++i) {
                    newFileRow[i] = fileRow[i];
                }
                newFileRow[ndegrees] = osmf;
                this.fileRows[latDegree] = newFileRow;
            }
            this.currentFileName = osmf.filename;
            if (osmf.microCaches == null) {
                return null;
            }
            int subIdx = (latIdx80 - 80 * latDegree) * 80 + (lonIdx80 - 80 * lonDegree);
            MicroCache segment = osmf.microCaches[subIdx];
            if (segment == null) {
                osmf.microCaches[subIdx] = segment = new MicroCache(osmf, lonIdx80, latIdx80, this.iobuffer);
                this.segmentList.add(segment);
            }
            return segment;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new RuntimeException("error reading datafile " + this.currentFileName + ": " + e);
        }
    }

    public boolean obtainNonHollowNode(OsmNode node) {
        if (!node.isHollow()) {
            return true;
        }
        MicroCache segment = this.getSegmentFor(node.ilon, node.ilat);
        if (segment == null) {
            return false;
        }
        segment.fillNode(node, this.nodesMap, this.distanceChecker);
        return !node.isHollow();
    }

    private OsmFile fileForSegment(int lonDegree, int latDegree) throws Exception {
        File base = new File(this.segmentDir);
        if (!base.isDirectory()) {
            throw new RuntimeException("segment directory " + this.segmentDir + " does not exist");
        }
        int lonMod5 = lonDegree % 5;
        int latMod5 = latDegree % 5;
        int tileIndex = lonMod5 * 5 + latMod5;
        int lon = lonDegree - 180 - lonMod5;
        String slon = lon < 0 ? "W" + -lon : "E" + lon;
        int lat = latDegree - 90 - latMod5;
        String slat = lat < 0 ? "S" + -lat : "N" + lat;
        String filenameBase = slon + "_" + slat;
        this.currentFileName = filenameBase + ".rd5/cd5";
        if (!this.fileCache.containsKey(filenameBase)) {
            File carFile;
            File f = null;
            if (this.carMode && (carFile = new File(new File(base, "carsubset"), filenameBase + ".cd5")).exists()) {
                f = carFile;
            }
            if (f == null) {
                f = new File(base, filenameBase + ".rd5");
            }
            RandomAccessFile ra = f.exists() ? new RandomAccessFile(f, "r") : null;
            this.fileCache.put(filenameBase, ra);
            if (ra != null) {
                long[] fileIndex = new long[25];
                ra.readFully(this.iobuffer, 0, 200);
                ByteDataReader dis = new ByteDataReader(this.iobuffer);
                for (int i = 0; i < 25; ++i) {
                    long lv = dis.readLong();
                    short readVersion = (short)(lv >> 48);
                    if (readVersion != this.lookupVersion) {
                        throw new IllegalArgumentException("lookup version mismatch (old rd5?) lookups.dat=" + this.lookupVersion + " " + f.getAbsolutePath() + "=" + readVersion);
                    }
                    fileIndex[i] = lv & 0xFFFFFFFFFFFFL;
                }
                this.indexCache.put(filenameBase, fileIndex);
            }
        }
        RandomAccessFile ra = this.fileCache.get(filenameBase);
        long startPos = 0L;
        if (ra != null) {
            long[] index = this.indexCache.get(filenameBase);
            long l = startPos = tileIndex > 0 ? index[tileIndex - 1] : 200L;
            if (startPos == index[tileIndex]) {
                ra = null;
            }
        }
        OsmFile osmf = new OsmFile(ra, startPos, this.iobuffer);
        osmf.lonDegree = lonDegree;
        osmf.latDegree = latDegree;
        osmf.filename = this.currentFileName;
        return osmf;
    }

    public List<OsmNode> getAllNodes() {
        ArrayList<OsmNode> all = new ArrayList<OsmNode>();
        for (MicroCache segment : this.segmentList) {
            List<OsmNode> positions = segment.getPositions(this.nodesMap);
            all.addAll(positions);
        }
        return all;
    }

    public void close() {
        for (RandomAccessFile f : this.fileCache.values()) {
            try {
                f.close();
            }
            catch (IOException iOException) {}
        }
    }
}

