/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpression;
import btools.expressions.BExpressionLookupValue;
import btools.expressions.BExpressionReceiver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class BExpressionContext {
    private static final String CONTEXT_TAG = "---context:";
    private static final String VERSION_TAG = "---lookupversion:";
    private String context;
    private boolean _inOurContext = false;
    private BufferedReader _br = null;
    private boolean _readerDone = false;
    private BExpressionReceiver _receiver;
    private Map<String, Integer> lookupNumbers = new HashMap<String, Integer>();
    private ArrayList<BExpressionLookupValue[]> lookupValues = new ArrayList();
    private ArrayList<String> lookupNames = new ArrayList();
    private ArrayList<int[]> lookupHistograms = new ArrayList();
    private boolean lookupDataFrozen = false;
    private int[] lookupData = new int[0];
    private Map<String, Integer> variableNumbers = new HashMap<String, Integer>();
    private float[] variableData;
    private long[] _arrayBitmap;
    private int currentHashBucket = -1;
    private long currentBitmap = 0L;
    public List<BExpression> expressionList;
    private int minWriteIdx;
    private int costfactorIdx;
    private int turncostIdx;
    private int initialcostIdx;
    private float[] _arrayCostfactor;
    private float[] _arrayTurncost;
    private float[] _arrayInitialcost;
    private int linenr;
    public short lookupVersion = (short)-1;
    private static int[] crctable = new int[]{0, 1996959894, -301047508, -1727442502, 124634137, 1886057615, -379345611, -1637575261, 249268274, 2044508324, -522852066, -1747789432, 162941995, 2125561021, -407360249, -1866523247, 498536548, 1789927666, -205950648, -2067906082, 450548861, 1843258603, -187386543, -2083289657, 325883990, 1684777152, -43845254, -1973040660, 335633487, 1661365465, -99664541, -1928851979, 997073096, 1281953886, -715111964, -1570279054, 1006888145, 1258607687, -770865667, -1526024853, 901097722, 1119000684, -608450090, -1396901568, 853044451, 1172266101, -589951537, -1412350631, 651767980, 1373503546, -925412992, -1076862698, 565507253, 1454621731, -809855591, -1195530993, 671266974, 1594198024, -972236366, -1324619484, 795835527, 1483230225, -1050600021, -1234817731, 1994146192, 31158534, -1731059524, -271249366, 1907459465, 112637215, -1614814043, -390540237, 2013776290, 251722036, -1777751922, -519137256, 2137656763, 141376813, -1855689577, -429695999, 1802195444, 476864866, -2056965928, -228458418, 1812370925, 453092731, -2113342271, -183516073, 1706088902, 314042704, -1950435094, -54949764, 1658658271, 366619977, -1932296973, -69972891, 1303535960, 984961486, -1547960204, -725929758, 1256170817, 1037604311, -1529756563, -740887301, 1131014506, 879679996, -1385723834, -631195440, 1141124467, 855842277, -1442165665, -586318647, 1342533948, 654459306, -1106571248, -921952122, 1466479909, 544179635, -1184443383, -832445281, 1591671054, 702138776, -1328506846, -942167884, 1504918807, 783551873, -1212326853, -1061524307, -306674912, -1698712650, 62317068, 1957810842, -355121351, -1647151185, 81470997, 1943803523, -480048366, -1805370492, 225274430, 2053790376, -468791541, -1828061283, 167816743, 2097651377, -267414716, -2029476910, 503444072, 1762050814, -144550051, -2140837941, 426522225, 1852507879, -19653770, -1982649376, 282753626, 1742555852, -105259153, -1900089351, 397917763, 1622183637, -690576408, -1580100738, 953729732, 1340076626, -776247311, -1497606297, 1068828381, 1219638859, -670225446, -1358292148, 906185462, 1090812512, -547295293, -1469587627, 829329135, 1181335161, -882789492, -1134132454, 628085408, 1382605366, -871598187, -1156888829, 570562233, 1426400815, -977650754, -1296233688, 733239954, 1555261956, -1026031705, -1244606671, 752459403, 1541320221, -1687895376, -328994266, 1969922972, 40735498, -1677130071, -351390145, 1913087877, 83908371, -1782625662, -491226604, 2075208622, 213261112, -1831694693, -438977011, 2094854071, 198958881, -2032938284, -237706686, 1759359992, 534414190, -2118248755, -155638181, 1873836001, 414664567, -2012718362, -15766928, 1711684554, 285281116, -1889165569, -127750551, 1634467795, 376229701, -1609899400, -686959890, 1308918612, 956543938, -1486412191, -799009033, 1231636301, 1047427035, -1362007478, -640263460, 1088359270, 936918000, -1447252397, -558129467, 1202900863, 817233897, -1111625188, -893730166, 1404277552, 615818150, -1160759803, -841546093, 1423857449, 601450431, -1285129682, -1000256840, 1567103746, 711928724, -1274298825, -1022587231, 1510334235, 755167117};

    public float getCostfactor() {
        return this._arrayCostfactor[this.currentHashBucket];
    }

    public float getTurncost() {
        return this._arrayTurncost[this.currentHashBucket];
    }

    public float getInitialcost() {
        return this._arrayInitialcost[this.currentHashBucket];
    }

    public BExpressionContext(String context) {
        this(context, 4096);
    }

    public BExpressionContext(String context, int hashSize) {
        this.context = context;
        this._arrayBitmap = new long[hashSize];
        this._arrayCostfactor = new float[hashSize];
        this._arrayTurncost = new float[hashSize];
        this._arrayInitialcost = new float[hashSize];
    }

    public long encode(int[] ld) {
        long w = 0L;
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            int n = this.lookupValues.get(inum).length - 1;
            int d = ld[inum];
            if (n == 2) {
                n = 1;
                int n2 = d = d == 2 ? 1 : 0;
            }
            while (n != 0) {
                n >>= 1;
                w <<= 1;
            }
            w |= (long)d;
        }
        return w;
    }

    public void decode(int[] ld, long w) {
        for (int inum = this.lookupValues.size() - 1; inum >= 0; --inum) {
            int nv = this.lookupValues.get(inum).length;
            int n = nv == 3 ? 1 : nv - 1;
            int m = 0;
            long ww = w;
            while (n != 0) {
                n >>= 1;
                ww >>= 1;
                m = m << 1 | 1;
            }
            int d = (int)(w & (long)m);
            if (nv == 3 && d == 1) {
                d = 2;
            }
            ld[inum] = d;
            w = ww;
        }
    }

    private void countBits() {
        int bits = 0;
        for (int inum = this.lookupValues.size() - 1; inum >= 0; --inum) {
            int n;
            int nv = this.lookupValues.get(inum).length;
            int n2 = n = nv == 3 ? 1 : nv - 1;
            while (n != 0) {
                n >>= 1;
                ++bits;
            }
        }
        if (bits > 64) {
            throw new IllegalArgumentException("lookup table for context " + this.context + " exceeds 64 bits!");
        }
    }

    public String getCsvDescription(long bitmap) {
        StringBuilder sb = new StringBuilder(200);
        this.decode(this.lookupData, bitmap);
        for (int inum = 0; inum < this.lookupValues.size(); ++inum) {
            BExpressionLookupValue[] va = this.lookupValues.get(inum);
            sb.append('\t').append(va[this.lookupData[inum]].toString());
        }
        return sb.toString();
    }

    public String getCsvHeader() {
        StringBuilder sb = new StringBuilder(200);
        for (String name : this.lookupNames) {
            sb.append('\t').append(name);
        }
        return sb.toString();
    }

    public void readMetaData(File lookupsFile) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(lookupsFile));
            int parsedLines = 0;
            boolean ourContext = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith(CONTEXT_TAG)) {
                    ourContext = line.substring(CONTEXT_TAG.length()).equals(this.context);
                    continue;
                }
                if (line.startsWith(VERSION_TAG)) {
                    this.lookupVersion = Short.parseShort(line.substring(VERSION_TAG.length()));
                    continue;
                }
                if (!ourContext) continue;
                ++parsedLines;
                StringTokenizer tk = new StringTokenizer(line, " ");
                String name = tk.nextToken();
                String value = tk.nextToken();
                int idx = name.indexOf(59);
                if (idx >= 0) {
                    name = name.substring(0, idx);
                }
                BExpressionLookupValue newValue = this.addLookupValue(name, value, null);
                while (newValue != null && tk.hasMoreTokens()) {
                    newValue.addAlias(tk.nextToken());
                }
            }
            br.close();
            if (parsedLines == 0 && !"global".equals(this.context)) {
                throw new IllegalArgumentException(lookupsFile.getAbsolutePath() + " does not contain data for context " + this.context + " (old version?)");
            }
            this.lookupDataFrozen = true;
            this.countBits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void evaluate(int[] lookupData2) {
        this.lookupData = lookupData2;
        for (BExpression exp : this.expressionList) {
            exp.evaluate(this);
        }
    }

    public void evaluate(long bitmap, BExpressionReceiver receiver) {
        this._receiver = receiver;
        if (this.currentBitmap != bitmap || this.currentHashBucket < 0) {
            int crc = -1;
            long bm = bitmap;
            for (int j = 0; j < 8; ++j) {
                crc = crc >>> 8 ^ crctable[(crc ^ (int)bm) & 0xFF];
                bm >>= 8;
            }
            int hashSize = this._arrayBitmap.length;
            this.currentHashBucket = (crc & 0xFFFFFFF) % hashSize;
            this.currentBitmap = bitmap;
        }
        if (this._arrayBitmap[this.currentHashBucket] == bitmap) {
            return;
        }
        this._arrayBitmap[this.currentHashBucket] = bitmap;
        this.decode(this.lookupData, bitmap);
        this.evaluate(this.lookupData);
        this._arrayCostfactor[this.currentHashBucket] = this.variableData[this.costfactorIdx];
        this._arrayTurncost[this.currentHashBucket] = this.variableData[this.turncostIdx];
        this._arrayInitialcost[this.currentHashBucket] = this.variableData[this.initialcostIdx];
        this._receiver = null;
    }

    public void dumpStatistics() {
        int[] histo;
        TreeMap<String, String> counts = new TreeMap<String, String>();
        for (String name : this.lookupNumbers.keySet()) {
            int cnt = 0;
            int inum = this.lookupNumbers.get(name);
            histo = this.lookupHistograms.get(inum);
            for (int i = 2; i < histo.length; ++i) {
                cnt += histo[i];
            }
            counts.put("" + (1000000000 + cnt) + "_" + name, name);
        }
        while (counts.size() > 0) {
            int i;
            String name;
            String key = (String)counts.lastEntry().getKey();
            name = (String)counts.get(key);
            counts.remove(key);
            int inum = this.lookupNumbers.get(name);
            BExpressionLookupValue[] values = this.lookupValues.get(inum);
            histo = this.lookupHistograms.get(inum);
            if (values.length == 1000) continue;
            Object[] svalues = new String[values.length];
            for (i = 0; i < values.length; ++i) {
                String scnt = "0000000000" + histo[i];
                scnt = scnt.substring(scnt.length() - 10);
                svalues[i] = scnt + " " + values[i].toString();
            }
            Arrays.sort(svalues);
            for (i = svalues.length - 1; i >= 0; --i) {
                System.out.println(name + ";" + (String)svalues[i]);
            }
        }
    }

    public int[] createNewLookupData() {
        if (this.lookupDataFrozen) {
            return new int[this.lookupValues.size()];
        }
        return null;
    }

    public BExpressionLookupValue addLookupValue(String name, String value, int[] lookupData2) {
        BExpressionLookupValue v;
        int i;
        BExpressionLookupValue newValue = null;
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            if (lookupData2 != null) {
                return newValue;
            }
            num = new Integer(this.lookupValues.size());
            this.lookupNumbers.put(name, num);
            this.lookupNames.add(name);
            this.lookupValues.add(new BExpressionLookupValue[]{new BExpressionLookupValue(""), new BExpressionLookupValue("unknown")});
            this.lookupHistograms.add(new int[2]);
            int[] ndata = new int[this.lookupData.length + 1];
            System.arraycopy(this.lookupData, 0, ndata, 0, this.lookupData.length);
            this.lookupData = ndata;
        }
        int inum = num;
        BExpressionLookupValue[] values = this.lookupValues.get(inum);
        int[] histo = this.lookupHistograms.get(inum);
        for (i = 0; i < values.length && !(v = values[i]).matches(value); ++i) {
        }
        if (i == values.length) {
            if (lookupData2 != null) {
                lookupData2[inum] = 1;
                return newValue;
            }
            if (i == 499) {
                // empty if block
            }
            if (i == 500) {
                return newValue;
            }
            BExpressionLookupValue[] nvalues = new BExpressionLookupValue[values.length + 1];
            int[] nhisto = new int[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            System.arraycopy(histo, 0, nhisto, 0, histo.length);
            values = nvalues;
            histo = nhisto;
            values[i] = newValue = new BExpressionLookupValue(value);
            this.lookupHistograms.set(inum, histo);
            this.lookupValues.set(inum, values);
        }
        int n = i;
        histo[n] = histo[n] + 1;
        if (lookupData2 != null) {
            lookupData2[inum] = i;
        } else {
            this.lookupData[inum] = i;
        }
        return newValue;
    }

    public void parseFile(File file, String readOnlyContext) {
        try {
            if (readOnlyContext != null) {
                this.linenr = 1;
                String realContext = this.context;
                this.context = readOnlyContext;
                this.expressionList = this._parseFile(file);
                this.variableData = new float[this.variableNumbers.size()];
                this.evaluate(1L, null);
                this.context = realContext;
            }
            this.linenr = 1;
            this.minWriteIdx = this.variableData == null ? 0 : this.variableData.length;
            this.costfactorIdx = this.getVariableIdx("costfactor", true);
            this.turncostIdx = this.getVariableIdx("turncost", true);
            this.initialcostIdx = this.getVariableIdx("initialcost", true);
            this.expressionList = this._parseFile(file);
            float[] readOnlyData = this.variableData;
            this.variableData = new float[this.variableNumbers.size()];
            for (int i = 0; i < this.minWriteIdx; ++i) {
                this.variableData[i] = readOnlyData[i];
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("ParseException at line " + this.linenr + ": " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
        if (this.expressionList.size() == 0) {
            throw new IllegalArgumentException(file.getAbsolutePath() + " does not contain expressions for context " + this.context + " (old version?)");
        }
    }

    private List<BExpression> _parseFile(File file) throws Exception {
        BExpression exp;
        this._br = new BufferedReader(new FileReader(file));
        this._readerDone = false;
        ArrayList<BExpression> result = new ArrayList<BExpression>();
        while ((exp = BExpression.parse(this, 0)) != null) {
            result.add(exp);
        }
        this._br.close();
        this._br = null;
        return result;
    }

    public float getVariableValue(String name, float defaultValue) {
        Integer num = this.variableNumbers.get(name);
        return num == null ? defaultValue : this.getVariableValue(num);
    }

    public float getVariableValue(String name) {
        Integer num = this.variableNumbers.get(name);
        return num == null ? 0.0f : this.getVariableValue(num);
    }

    public float getVariableValue(int variableIdx) {
        return this.variableData[variableIdx];
    }

    public int getVariableIdx(String name, boolean create) {
        Integer num = this.variableNumbers.get(name);
        if (num == null) {
            if (create) {
                num = new Integer(this.variableNumbers.size());
                this.variableNumbers.put(name, num);
            } else {
                return -1;
            }
        }
        return num;
    }

    public int getMinWriteIdx() {
        return this.minWriteIdx;
    }

    public float getLookupMatch(int nameIdx, int valueIdx) {
        return this.lookupData[nameIdx] == valueIdx ? 1.0f : 0.0f;
    }

    public int getLookupNameIdx(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num == null ? -1 : num;
    }

    public int getLookupValueIdx(int nameIdx, String value) {
        BExpressionLookupValue[] values = this.lookupValues.get(nameIdx);
        for (int i = 0; i < values.length; ++i) {
            if (!values[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    public String parseToken() throws Exception {
        String token;
        while (true) {
            if ((token = this._parseToken()) == null) {
                return null;
            }
            if (token.startsWith(CONTEXT_TAG)) {
                this._inOurContext = token.substring(CONTEXT_TAG.length()).equals(this.context);
                continue;
            }
            if (this._inOurContext) break;
        }
        return token;
    }

    private String _parseToken() throws Exception {
        StringBuilder sb = new StringBuilder(32);
        boolean inComment = false;
        while (true) {
            int ic;
            int n = ic = this._readerDone ? -1 : this._br.read();
            if (ic < 0) {
                if (sb.length() == 0) {
                    return null;
                }
                this._readerDone = true;
                return sb.toString();
            }
            char c = (char)ic;
            if (c == '\n') {
                ++this.linenr;
            }
            if (inComment) {
                if (c != '\r' && c != '\n') continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
            if (c == '#' && sb.length() == 0) {
                inComment = true;
                continue;
            }
            sb.append(c);
        }
    }

    public float assign(int variableIdx, float value) {
        this.variableData[variableIdx] = value;
        return value;
    }

    public void expressionWarning(String message) {
        this._arrayBitmap[this.currentHashBucket] = 0L;
        if (this._receiver != null) {
            this._receiver.expressionWarning(this.context, message);
        }
    }
}

