/*
 * Decompiled with CFR 0.152.
 */
package btools.util;

import java.util.ArrayList;

public class DenseLongMap {
    private ArrayList<int[]> blocklist = new ArrayList(1024);
    private static final int BLOCKSIZE = 65536;
    private int valuebits;
    private int maxvalue;
    private long maxkey;
    private long maxmemory;

    public DenseLongMap(int valuebits) {
        if (valuebits < 1 || valuebits > 32) {
            throw new IllegalArgumentException("invalid valuebits (1..32): " + valuebits);
        }
        this.valuebits = valuebits;
        this.maxmemory = Runtime.getRuntime().maxMemory() / 8L * 7L;
        this.maxvalue = (1 << valuebits) - 2;
        this.maxkey = this.maxmemory / (long)valuebits * 8L;
    }

    public void put(long key, int value) {
        int[] block;
        if (key < 0L || key > this.maxkey) {
            throw new IllegalArgumentException("key out of range (0.." + this.maxkey + "): " + key + " give more memory (currently " + this.maxmemory / 0x100000L + "MB) to extend key range");
        }
        if (value < 0 || value > this.maxvalue) {
            throw new IllegalArgumentException("value out of range (0.." + this.maxvalue + "): " + value);
        }
        int blockn = (int)(key >> 21);
        int offset = (int)(key & 0x1FFFFFL);
        int[] nArray = block = blockn < this.blocklist.size() ? this.blocklist.get(blockn) : null;
        if (block == null) {
            block = new int[65536 * this.valuebits];
            while (this.blocklist.size() < blockn + 1) {
                this.blocklist.add(null);
            }
            this.blocklist.set(blockn, block);
        }
        int bitmask = 1 << (offset & 0x1F);
        int invmask = ~bitmask;
        int probebit = 1;
        int blockidx = (offset >> 5) * this.valuebits;
        int blockend = blockidx + this.valuebits;
        int v = value + 1;
        while (blockidx < blockend) {
            if ((v & probebit) != 0) {
                int n = blockidx;
                block[n] = block[n] | bitmask;
            } else {
                int n = blockidx;
                block[n] = block[n] & invmask;
            }
            probebit <<= 1;
            ++blockidx;
        }
    }

    public int getInt(long key) {
        int[] block;
        if (key < 0L) {
            return -1;
        }
        int blockn = (int)(key >> 21);
        int offset = (int)(key & 0x1FFFFFL);
        int[] nArray = block = blockn < this.blocklist.size() ? this.blocklist.get(blockn) : null;
        if (block == null) {
            return -1;
        }
        int bitmask = 1 << (offset & 0x1F);
        int probebit = 1;
        int blockidx = (offset >> 5) * this.valuebits;
        int blockend = blockidx + this.valuebits;
        int v = 0;
        while (blockidx < blockend) {
            if ((block[blockidx] & bitmask) != 0) {
                v |= probebit;
            }
            probebit <<= 1;
            ++blockidx;
        }
        return v - 1;
    }
}

