/*
 * Decompiled with CFR 0.152.
 */
package btools.server;

import btools.router.OsmNodeNamed;
import btools.router.RoutingContext;
import btools.router.RoutingEngine;
import java.net.URLDecoder;
import java.util.ArrayList;

public class BRouter {
    public static void main(String[] args) throws Exception {
        if (args.length == 2) {
            block19: {
                try {
                    int maxKm;
                    String queryString = args[1];
                    int sepIdx = queryString.indexOf(61);
                    if (sepIdx >= 0) {
                        queryString = queryString.substring(sepIdx + 1);
                    }
                    queryString = URLDecoder.decode(queryString, "ISO-8859-1");
                    int ntokens = 1;
                    int ic = 0;
                    while (ic < queryString.length()) {
                        if (queryString.charAt(ic) == '_') {
                            ++ntokens;
                        }
                        ++ic;
                    }
                    String[] a2 = new String[ntokens + 1];
                    int idx = 1;
                    int pos = 0;
                    while (true) {
                        int p;
                        if ((p = queryString.indexOf(95, pos)) < 0) break;
                        a2[idx++] = queryString.substring(pos, p);
                        pos = p + 1;
                    }
                    a2[idx++] = queryString.substring(pos);
                    System.out.println("Content-type: text/plain");
                    System.out.println();
                    OsmNodeNamed from = BRouter.readPosition(a2, 1, "from");
                    OsmNodeNamed to = BRouter.readPosition(a2, 3, "to");
                    int airDistance = from.calcDistance(to);
                    String airDistanceLimit = System.getProperty("airDistanceLimit");
                    if (airDistanceLimit != null && airDistance > (maxKm = Integer.parseInt(airDistanceLimit)) * 1000) {
                        System.out.println("airDistance " + airDistance / 1000 + "km exceeds limit for online router (" + maxKm + "km)");
                        return;
                    }
                    long maxRunningTime = 60000L;
                    String sMaxRunningTime = System.getProperty("maxRunningTime");
                    if (sMaxRunningTime != null) {
                        maxRunningTime = Integer.parseInt(sMaxRunningTime) * 1000;
                    }
                    long startTime = System.currentTimeMillis();
                    ArrayList<OsmNodeNamed> wplist = new ArrayList<OsmNodeNamed>();
                    wplist.add(from);
                    wplist.add(to);
                    RoutingEngine cr = new RoutingEngine(null, null, args[0], wplist, BRouter.readRoutingContext(a2));
                    cr.start();
                    do {
                        if (System.currentTimeMillis() - startTime > maxRunningTime) {
                            System.out.println("routing interrupted after " + maxRunningTime + " seconds");
                            break block19;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!cr.isFinished());
                    if (cr.getErrorMessage() != null) {
                        System.out.println(cr.getErrorMessage());
                    }
                }
                catch (Throwable e) {
                    System.out.println("unexpected exception: " + e);
                }
            }
            System.exit(0);
        }
        System.out.println("BRouter 0.95 / 01092013 / abrensch");
        if (args.length < 6) {
            System.out.println("Find routes in an OSM map");
            System.out.println("usage: java -jar brouter.jar <segmentdir> <lon-from> <lat-from> <lon-to> <lat-to> <profile>");
            return;
        }
        ArrayList<OsmNodeNamed> wplist = new ArrayList<OsmNodeNamed>();
        wplist.add(BRouter.readPosition(args, 1, "from"));
        wplist.add(BRouter.readPosition(args, 3, "to"));
        RoutingEngine re = new RoutingEngine("mytrack", "mylog", args[0], wplist, BRouter.readRoutingContext(args));
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!re.isFinished());
        if (re.getErrorMessage() != null) {
            System.out.println(re.getErrorMessage());
        }
    }

    private static OsmNodeNamed readPosition(String[] args, int idx, String name) {
        OsmNodeNamed n = new OsmNodeNamed();
        n.name = name;
        n.ilon = (int)((Double.parseDouble(args[idx]) + 180.0) * 1000000.0 + 0.5);
        n.ilat = (int)((Double.parseDouble(args[idx + 1]) + 90.0) * 1000000.0 + 0.5);
        return n;
    }

    private static RoutingContext readRoutingContext(String[] args) {
        RoutingContext c = new RoutingContext();
        if (args.length > 5) {
            c.localFunction = args[5];
            if (args.length > 6) {
                c.setAlternativeIdx(Integer.parseInt(args[6]));
            }
        }
        return c;
    }
}

