/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.expressions.BExpressionContext;
import btools.mapaccess.NodesCache;
import btools.mapaccess.OsmLink;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import btools.router.MatchedWaypoint;
import btools.router.OpenSet;
import btools.router.OsmNodeNamed;
import btools.router.OsmPath;
import btools.router.OsmPathElement;
import btools.router.OsmTrack;
import btools.router.RoutingContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class RoutingEngine
extends Thread {
    private OsmNodesMap nodesMap;
    private NodesCache nodesCache;
    private OpenSet openSet = new OpenSet();
    private boolean finished = false;
    private List<OsmNodeNamed> waypoints = null;
    private int linksProcessed = 0;
    private OsmTrack foundTrack = new OsmTrack();
    private OsmTrack foundRawTrack = null;
    private String errorMessage = null;
    private volatile boolean terminated;
    private String segmentDir;
    private String outfileBase;
    private String logfileBase;
    private boolean infoLogEnabled;
    private RoutingContext routingContext;
    private double airDistanceCostFactor;
    private OsmTrack guideTrack;
    private OsmPathElement matchPath;
    private long startTime;
    private long maxRunningTime;
    public boolean quite = false;

    public RoutingEngine(String outfileBase, String logfileBase, String segmentDir, List<OsmNodeNamed> waypoints, RoutingContext rc) {
        this.segmentDir = segmentDir;
        this.outfileBase = outfileBase;
        this.logfileBase = logfileBase;
        this.waypoints = waypoints;
        this.infoLogEnabled = outfileBase != null;
        this.routingContext = rc;
        if (rc.localFunction != null) {
            File profileFile;
            File profileDir;
            String profileBaseDir = System.getProperty("profileBaseDir");
            if (profileBaseDir == null) {
                profileDir = new File(rc.localFunction).getParentFile();
                profileFile = new File(rc.localFunction);
            } else {
                profileDir = new File(profileBaseDir);
                profileFile = new File(profileDir, String.valueOf(rc.localFunction) + ".brf");
            }
            BExpressionContext expctxGlobal = new BExpressionContext("global");
            expctxGlobal.readMetaData(new File(profileDir, "lookups.dat"));
            expctxGlobal.parseFile(profileFile, null);
            expctxGlobal.evaluate(1L, rc.messageHandler);
            rc.readGlobalConfig(expctxGlobal);
            rc.expctxWay = new BExpressionContext("way", 4096);
            rc.expctxWay.readMetaData(new File(profileDir, "lookups.dat"));
            rc.expctxWay.parseFile(profileFile, "global");
            rc.expctxNode = new BExpressionContext("node", 1024);
            rc.expctxNode.readMetaData(new File(profileDir, "lookups.dat"));
            rc.expctxNode.parseFile(profileFile, "global");
        }
    }

    private void logInfo(String s) {
        if (this.infoLogEnabled) {
            System.out.println(s);
        }
    }

    @Override
    public void run() {
        this.doRun(0L);
    }

    /*
     * Unable to fully structure code
     */
    public void doRun(long maxRunningTime) {
        try {
            try {
                this.startTime = System.currentTimeMillis();
                this.maxRunningTime = maxRunningTime;
                sum = null;
                track = null;
                messageList = new ArrayList<String>();
                i = 0;
                while (!this.terminated) {
                    block16: {
                        block14: {
                            block15: {
                                track = this.findTrack(sum);
                                track.message = "track-length = " + track.distance + " filtered ascend = " + track.ascend + " plain-ascend = " + track.plainAscend + " cost=" + track.cost;
                                track.name = "brouter_" + this.routingContext.getProfileName() + "_" + i;
                                messageList.add(track.message);
                                track.messageList = messageList;
                                if (this.outfileBase == null) break block14;
                                filename = String.valueOf(this.outfileBase) + i + ".gpx";
                                oldTrack = new OsmTrack();
                                oldTrack.readGpx(filename);
                                if (!track.equalsTrack(oldTrack)) break block15;
                                if (sum == null) {
                                    sum = new OsmTrack();
                                }
                                sum.addNodes(track);
                                break block16;
                            }
                            track.writeGpx(filename);
                            this.foundTrack = track;
                            ** GOTO lbl41
                        }
                        if (i != this.routingContext.getAlternativeIdx()) {
                            if (sum == null) {
                                sum = new OsmTrack();
                            }
                            sum.addNodes(track);
                        } else {
                            if ("CSV".equals(System.getProperty("reportFormat"))) {
                                track.dumpMessages(null, this.routingContext);
                            } else if (!this.quite) {
                                System.out.println(track.formatAsGpx());
                            }
                            this.foundTrack = track;
lbl41:
                            // 2 sources

                            if (this.logfileBase == null) break;
                            logfilename = String.valueOf(this.logfileBase) + i + ".csv";
                            track.dumpMessages(logfilename, this.routingContext);
                            break;
                        }
                    }
                    ++i;
                }
                endTime = System.currentTimeMillis();
                this.logInfo("execution time = " + (double)(endTime - this.startTime) / 1000.0 + " seconds");
            }
            catch (Exception e) {
                this.errorMessage = e instanceof IllegalArgumentException != false ? e.getMessage() : e.toString();
                this.logInfo("Exception (linksProcessed=" + this.linksProcessed + ": " + this.errorMessage);
                e.printStackTrace();
                this.openSet.clear();
                this.finished = true;
            }
        }
        finally {
            this.openSet.clear();
            this.finished = true;
        }
    }

    private OsmTrack findTrack(OsmTrack refTrack) {
        OsmTrack totaltrack = new OsmTrack();
        MatchedWaypoint[] wayointIds = new MatchedWaypoint[this.waypoints.size()];
        OsmTrack nearbyTrack = null;
        if (refTrack == null && (nearbyTrack = OsmTrack.readBinary(this.routingContext.rawTrackPath, this.waypoints.get(this.waypoints.size() - 1))) != null) {
            wayointIds[this.waypoints.size() - 1] = nearbyTrack.endPoint;
        }
        int i = 0;
        while (i < this.waypoints.size()) {
            if (wayointIds[i] == null) {
                wayointIds[i] = this.matchNodeForPosition(this.waypoints.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < this.waypoints.size() - 1) {
            OsmTrack seg = this.searchTrack(wayointIds[i], wayointIds[i + 1], i == this.waypoints.size() - 2 ? nearbyTrack : null, refTrack);
            if (seg == null) {
                return null;
            }
            totaltrack.appendTrack(seg);
            ++i;
        }
        return totaltrack;
    }

    private MatchedWaypoint matchNodeForPosition(OsmNodeNamed wp) {
        try {
            this.routingContext.setWaypoint(wp, false);
            MatchedWaypoint matchedWaypoint = this._matchNodeForPosition(wp);
            return matchedWaypoint;
        }
        finally {
            this.routingContext.unsetWaypoint();
        }
    }

    private MatchedWaypoint _matchNodeForPosition(OsmNodeNamed wp) {
        wp.radius = 1.0E9;
        this.resetCache();
        this.preloadPosition(wp);
        this.nodesCache.distanceChecker = this.routingContext;
        List<OsmNode> nodeList = this.nodesCache.getAllNodes();
        MatchedWaypoint mwp = new MatchedWaypoint();
        mwp.waypoint = wp;
        for (OsmNode n : nodeList) {
            if (!this.nodesCache.obtainNonHollowNode(n)) continue;
            this.expandHollowLinkTargets(n, false);
            OsmLink startLink = new OsmLink();
            startLink.targetNode = n;
            OsmPath startPath = new OsmPath(startLink);
            startLink.addLinkHolder(startPath);
            OsmLink link = n.firstlink;
            while (link != null) {
                OsmNode nextNode;
                if (!link.counterLinkWritten && !(nextNode = link.targetNode).isHollow() && nextNode.firstlink != null && nextNode != n) {
                    double oldRadius = wp.radius;
                    OsmPath testPath = new OsmPath(n, startPath, link, null, false, this.routingContext);
                    if (wp.radius < oldRadius) {
                        if (testPath.cost < 0) {
                            wp.radius = oldRadius;
                        } else {
                            mwp.node1 = n;
                            mwp.node2 = nextNode;
                            mwp.radius = wp.radius;
                            mwp.crosspoint = new OsmNodeNamed();
                            mwp.crosspoint.ilon = this.routingContext.ilonshortest;
                            mwp.crosspoint.ilat = this.routingContext.ilatshortest;
                        }
                    }
                }
                link = link.next;
            }
        }
        if (mwp.node1 == null) {
            throw new IllegalArgumentException(String.valueOf(wp.name) + "-position not mapped");
        }
        return mwp;
    }

    private void expandHollowLinkTargets(OsmNode n, boolean failOnReverseNotFound) {
        OsmLink link = n.firstlink;
        while (link != null) {
            if (this.nodesCache.obtainNonHollowNode(link.targetNode) && link.counterLinkWritten) {
                OsmLink rlink = link.targetNode.getReverseLink(n.getILon(), n.getILat());
                if (rlink == null) {
                    if (failOnReverseNotFound) {
                        throw new RuntimeException("reverse link not found!");
                    }
                } else {
                    link.descriptionBitmap = rlink.descriptionBitmap;
                    link.firsttransferBytes = rlink.firsttransferBytes;
                    link.counterLinkWritten = false;
                }
            }
            link = link.next;
        }
        n.wasProcessed = true;
    }

    private OsmTrack searchTrack(MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack nearbyTrack, OsmTrack refTrack) {
        OsmTrack track = null;
        double[] airDistanceCostFactors = new double[]{2.0, 1.5, 0.0};
        boolean isDirty = false;
        this.matchPath = null;
        if (nearbyTrack != null) {
            this.airDistanceCostFactor = 0.0;
            try {
                track = this.findTrack(startWp, endWp, nearbyTrack, refTrack);
            }
            catch (IllegalArgumentException iae) {
                if (this.matchPath != null) {
                    track = this.mergeTrack(this.matchPath, nearbyTrack);
                    isDirty = true;
                }
                this.maxRunningTime += System.currentTimeMillis() - this.startTime;
            }
        }
        if (track == null) {
            int cfi = 0;
            while (cfi < airDistanceCostFactors.length && !this.terminated) {
                this.airDistanceCostFactor = airDistanceCostFactors[cfi];
                OsmTrack t = this.findTrack(startWp, endWp, track, refTrack);
                if (t != null) {
                    track = t;
                } else {
                    this.logInfo("no track for cfi=" + cfi);
                }
                ++cfi;
            }
        }
        if (track == null) {
            throw new IllegalArgumentException("no track found");
        }
        if (refTrack == null && !isDirty) {
            track.endPoint = endWp;
            this.foundRawTrack = track;
        }
        this.airDistanceCostFactor = 0.0;
        this.guideTrack = track;
        try {
            OsmTrack tt = this.findTrack(startWp, endWp, null, refTrack);
            if (tt == null) {
                throw new IllegalArgumentException("error re-tracking track");
            }
            OsmTrack osmTrack = tt;
            return osmTrack;
        }
        finally {
            this.guideTrack = null;
        }
    }

    private void resetCache() {
        this.nodesMap = new OsmNodesMap();
        this.nodesCache = new NodesCache(this.segmentDir, this.nodesMap, this.routingContext.expctxWay.lookupVersion, this.routingContext.carMode, this.nodesCache);
    }

    private OsmNode getStartNode(long startId) {
        OsmNode start = this.nodesMap.get(startId);
        if (start == null) {
            start = new OsmNode(startId);
            start.setHollow();
            this.nodesMap.put(startId, start);
        }
        if (!this.nodesCache.obtainNonHollowNode(start)) {
            return null;
        }
        this.expandHollowLinkTargets(start, true);
        return start;
    }

    private OsmPath getStartPath(OsmNode n1, OsmNode n2, MatchedWaypoint mwp, OsmNode endPos) {
        OsmNodeNamed wp = mwp.waypoint;
        try {
            this.routingContext.setWaypoint(wp, false);
            OsmPath bestPath = null;
            OsmLink bestLink = null;
            OsmLink startLink = new OsmLink();
            startLink.targetNode = n1;
            OsmPath startPath = new OsmPath(startLink);
            startLink.addLinkHolder(startPath);
            double minradius = 1.0E10;
            OsmLink link = n1.firstlink;
            while (link != null) {
                OsmNode nextNode = link.targetNode;
                if (!nextNode.isHollow() && nextNode.firstlink != null && nextNode != n1 && nextNode == n2) {
                    wp.radius = 1.0E9;
                    OsmPath testPath = new OsmPath(null, startPath, link, null, this.guideTrack != null, this.routingContext);
                    testPath.setAirDistanceCostAdjustment((int)((double)nextNode.calcDistance(endPos) * this.airDistanceCostFactor));
                    if (wp.radius < minradius) {
                        bestPath = testPath;
                        minradius = wp.radius;
                        bestLink = link;
                    }
                }
                link = link.next;
            }
            if (bestLink != null) {
                bestLink.addLinkHolder(bestPath);
            }
            bestPath.treedepth = 1;
            OsmPath osmPath = bestPath;
            return osmPath;
        }
        finally {
            this.routingContext.unsetWaypoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private OsmTrack findTrack(MatchedWaypoint startWp, MatchedWaypoint endWp, OsmTrack costCuttingTrack, OsmTrack refTrack) {
        verbose = this.guideTrack != null;
        maxTotalCost = 1000000000;
        this.logInfo("findtrack with maxTotalCost=" + maxTotalCost + " airDistanceCostFactor=" + this.airDistanceCostFactor);
        nodesVisited = 0;
        this.resetCache();
        endNodeId1 = endWp.node1.getIdFromPos();
        endNodeId2 = endWp.node2.getIdFromPos();
        endPos = endWp.crosspoint;
        start1 = this.getStartNode(startWp.node1.getIdFromPos());
        start2 = this.getStartNode(startWp.node2.getIdFromPos());
        if (start1 == null || start2 == null) {
            return null;
        }
        startPath1 = this.getStartPath(start1, start2, startWp, endPos);
        startPath2 = this.getStartPath(start2, start1, startWp, endPos);
        var17_15 = this.openSet;
        synchronized (var17_15) {
            this.openSet.clear();
            if (startPath1.cost >= 0) {
                this.openSet.add(startPath1);
            }
            if (startPath2.cost >= 0) {
                this.openSet.add(startPath2);
            }
            // MONITOREXIT @DISABLED, blocks:[0, 5] lbl23 : MonitorExitStatement: MONITOREXIT : var17_15
            if (true) ** GOTO lbl131
        }
        do {
            if (this.maxRunningTime > 0L) {
                v1 = timeout = this.matchPath == null ? this.maxRunningTime / 3L : this.maxRunningTime;
                if (System.currentTimeMillis() - this.startTime > timeout) {
                    throw new IllegalArgumentException("routing timeout after " + timeout / 1000L + " seconds");
                }
            }
            path = null;
            var18_17 = this.openSet;
            synchronized (var18_17) {
                if (this.openSet.size() == 0) {
                    break;
                }
                path = this.openSet.first();
                this.openSet.remove(path);
            }
            if (path.cost > maxTotalCost) continue;
            ++nodesVisited;
            ++this.linksProcessed;
            currentLink = path.getLink();
            currentNode = currentLink.targetNode;
            sourceNode = path.getSourceNode();
            currentNodeId = currentNode.getIdFromPos();
            if (sourceNode != null && ((sourceNodeId = sourceNode.getIdFromPos()) == endNodeId1 && currentNodeId == endNodeId2 || sourceNodeId == endNodeId2 && currentNodeId == endNodeId1)) {
                this.logInfo("found track at cost " + path.cost + " nodesVisited = " + nodesVisited);
                return this.compileTrack(path, verbose);
            }
            if (!currentNode.wasProcessed) {
                this.expandHollowLinkTargets(currentNode, true);
                this.nodesMap.removeCompletedNodes();
            }
            if (sourceNode != null) {
                sourceNode.unlinkLink(currentLink);
            }
            counterLink = null;
            link = currentNode.firstlink;
            while (link != null) {
                block38: {
                    block40: {
                        block39: {
                            nextNode = link.targetNode;
                            if (nextNode.isHollow() || nextNode.firstlink == null) break block38;
                            if (nextNode != sourceNode) break block39;
                            counterLink = link;
                            break block38;
                        }
                        if (this.guideTrack == null) break block40;
                        gidx = path.treedepth + 1;
                        if (gidx >= this.guideTrack.nodes.size()) break block38;
                        guideNode = this.guideTrack.nodes.get(gidx);
                        if (nextNode.getILat() != guideNode.getILat() || nextNode.getILon() != guideNode.getILon()) break block38;
                    }
                    bestPath = null;
                    isFinalLink = false;
                    targetNodeId = link.targetNode.getIdFromPos();
                    if (!(currentNodeId != endNodeId1 && currentNodeId != endNodeId2 || targetNodeId != endNodeId1 && targetNodeId != endNodeId2)) {
                        isFinalLink = true;
                    }
                    linkHolder = currentLink.firstlinkholder;
                    while (linkHolder != null) {
                        otherPath = (OsmPath)linkHolder;
                        try {
                            if (isFinalLink) {
                                endWp.crosspoint.radius = 1.0E-5;
                                this.routingContext.setWaypoint(endWp.crosspoint, true);
                            }
                            testPath = new OsmPath(currentNode, otherPath, link, refTrack, this.guideTrack != null, this.routingContext);
                            if (testPath.cost >= 0 && (bestPath == null || testPath.cost < bestPath.cost)) {
                                bestPath = testPath;
                            }
                        }
                        finally {
                            this.routingContext.unsetWaypoint();
                        }
                        if (otherPath != path) {
                            testPath = this.openSet;
                            synchronized (testPath) {
                                this.openSet.remove(otherPath);
                            }
                        }
                        linkHolder = linkHolder.getNextForLink();
                    }
                    if (bestPath != null) {
                        airDistance = isFinalLink != false ? 0 : nextNode.calcDistance(endPos);
                        bestPath.setAirDistanceCostAdjustment((int)((double)airDistance * this.airDistanceCostFactor));
                        if (costCuttingTrack != null && (pe = costCuttingTrack.getLink(currentNodeId, targetNodeId)) != null && (costEstimate = bestPath.cost + bestPath.elevationCorrection(this.routingContext) + (costCuttingTrack.cost - pe.cost)) < maxTotalCost) {
                            this.logInfo("maxcost " + maxTotalCost + " -> " + costEstimate);
                            maxTotalCost = costEstimate;
                            this.matchPath = new OsmPathElement(bestPath);
                        }
                        if (bestPath.cost + airDistance <= maxTotalCost + 10) {
                            dominator = link.firstlinkholder;
                            while (dominator != null) {
                                if (bestPath.definitlyWorseThan((OsmPath)dominator, this.routingContext)) break;
                                dominator = dominator.getNextForLink();
                            }
                            if (dominator == null) {
                                bestPath.treedepth = path.treedepth + 1;
                                link.addLinkHolder(bestPath);
                                var32_33 = this.openSet;
                                synchronized (var32_33) {
                                    this.openSet.add(bestPath);
                                }
                            }
                        }
                    }
                }
                link = link.next;
            }
            if (counterLink == null || counterLink.firstlinkholder != null) continue;
            currentNode.unlinkLink(counterLink);
lbl131:
            // 4 sources

        } while (!this.terminated);
        return null;
    }

    private void preloadPosition(OsmNode n) {
        int d = 6250;
        this.nodesCache.getSegmentFor(n.ilon + d, n.ilat + d);
        this.nodesCache.getSegmentFor(n.ilon - d, n.ilat + d);
        this.nodesCache.getSegmentFor(n.ilon + d, n.ilat - d);
        this.nodesCache.getSegmentFor(n.ilon - d, n.ilat - d);
    }

    private OsmTrack compileTrack(OsmPath path, boolean verbose) {
        OsmPathElement element = new OsmPathElement(path);
        if (this.guideTrack != null) {
            element = element.origin;
        }
        OsmTrack track = new OsmTrack();
        track.cost = path.cost;
        int distance = 0;
        double ascend = 0.0;
        double ehb = 0.0;
        while (element != null) {
            track.addNode(element);
            OsmPathElement nextElement = element.origin;
            if (nextElement != null) {
                distance += element.calcDistance(nextElement);
                if ((ehb += (double)(element.getSElev() - nextElement.getSElev()) / 4.0) > 10.0) {
                    ascend += ehb - 10.0;
                    ehb = 10.0;
                } else if (ehb < 0.0) {
                    ehb = 0.0;
                }
            }
            element = nextElement;
        }
        track.distance = distance;
        track.ascend = (int)(ascend += ehb);
        track.plainAscend = (track.nodes.get(track.nodes.size() - 1).getSElev() - track.nodes.get(0).getSElev()) / 4;
        this.logInfo("track-length = " + track.distance);
        this.logInfo("filtered ascend = " + track.ascend);
        track.buildMap();
        return track;
    }

    private OsmTrack mergeTrack(OsmPathElement match, OsmTrack oldTrack) {
        OsmPathElement element = match;
        OsmTrack track = new OsmTrack();
        while (element != null) {
            track.addNode(element);
            element = element.origin;
        }
        long lastId = 0L;
        long id1 = match.getIdFromPos();
        long id0 = match.origin == null ? 0L : match.origin.getIdFromPos();
        boolean appending = false;
        for (OsmPathElement n : oldTrack.nodes) {
            long id;
            if (appending) {
                track.nodes.add(n);
            }
            if ((id = n.getIdFromPos()) == id1 && lastId == id0) {
                appending = true;
            }
            lastId = id;
        }
        track.buildMap();
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getOpenSet() {
        OpenSet openSet = this.openSet;
        synchronized (openSet) {
            return this.openSet.getExtract();
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public int getLinksProcessed() {
        return this.linksProcessed;
    }

    public int getDistance() {
        return this.foundTrack.distance;
    }

    public int getAscend() {
        return this.foundTrack.ascend;
    }

    public int getPlainAscend() {
        return this.foundTrack.plainAscend;
    }

    public OsmTrack getFoundTrack() {
        return this.foundTrack;
    }

    public OsmTrack getFoundRawTrack() {
        return this.foundRawTrack;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void terminate() {
        this.terminated = true;
    }
}

