/*
 * Decompiled with CFR 0.152.
 */
package btools.router;

import btools.mapaccess.OsmNode;
import btools.router.OsmPath;

public class OpenSet {
    private OsmPath start = new OsmPath();
    private OsmPath index2 = new OsmPath();
    private int addCount = 0;
    private int size = 0;

    public void clear() {
        this.start.nextInSet = null;
        this.start.nextInIndexSet = null;
        this.index2.nextInIndexSet = null;
        this.size = 0;
        this.addCount = 0;
    }

    public void add(OsmPath path) {
        int ac = path.adjustedCost;
        OsmPath p1 = this.index2;
        while (p1.nextInIndexSet != null && p1.nextInIndexSet.adjustedCost < ac) {
            p1 = p1.nextInIndexSet;
        }
        if (p1 == this.index2) {
            p1 = this.start;
        }
        while (true) {
            if (p1.nextInIndexSet != null && p1.nextInIndexSet.adjustedCost < ac) {
                p1 = p1.nextInIndexSet;
                continue;
            }
            if (p1.nextInSet == null || p1.nextInSet.adjustedCost >= ac) break;
            p1 = p1.nextInSet;
        }
        OsmPath p2 = p1.nextInSet;
        p1.nextInSet = path;
        path.prevInSet = p1;
        path.nextInSet = p2;
        if (p2 != null) {
            p2.prevInSet = path;
        }
        ++this.size;
        ++this.addCount;
        if ((this.addCount & 0x1F) == 0) {
            this.addIndex(path, this.start);
        } else if ((this.addCount & 0x3FF) == 1023) {
            this.addIndex(path, this.index2);
        }
    }

    public void remove(OsmPath path) {
        OsmPath p1 = path.prevInSet;
        OsmPath p2 = path.nextInSet;
        if (p1 == null) {
            return;
        }
        path.prevInSet = null;
        path.nextInSet = null;
        if (p2 != null) {
            p2.prevInSet = p1;
        }
        p1.nextInSet = p2;
        this.removeIndex(path);
        --this.size;
    }

    public OsmPath first() {
        return this.start.nextInSet;
    }

    public int size() {
        return this.size;
    }

    public int[] getExtract() {
        int div = this.size / 1000 + 1;
        int[] res = new int[this.size / div * 2];
        int i = 0;
        int cnt = 0;
        OsmPath p = this.start.nextInSet;
        while (p != null) {
            if (++cnt % div == 0) {
                OsmNode n = p.getLink().targetNode;
                res[i++] = n.ilon;
                res[i++] = n.ilat;
            }
            p = p.nextInSet;
        }
        return res;
    }

    private void addIndex(OsmPath path, OsmPath index) {
        int ac = path.adjustedCost;
        OsmPath p1 = index;
        OsmPath p2 = p1.nextInIndexSet;
        while (p2 != null && p2.adjustedCost < ac) {
            p1 = p2;
            p2 = p2.nextInIndexSet;
        }
        p1.nextInIndexSet = path;
        path.prevInIndexSet = p1;
        path.nextInIndexSet = p2;
        if (p2 != null) {
            p2.prevInIndexSet = path;
        }
    }

    private void removeIndex(OsmPath path) {
        OsmPath p1 = path.prevInIndexSet;
        OsmPath p2 = path.nextInIndexSet;
        if (p1 == null) {
            return;
        }
        path.prevInIndexSet = null;
        path.nextInIndexSet = null;
        if (p2 != null) {
            p2.prevInIndexSet = p1;
        }
        p1.nextInIndexSet = p2;
    }
}

