/*
 * Decompiled with CFR 0.152.
 */
package btools.mapcreator;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SrtmData {
    public int ncols;
    public int nrows;
    public double xllcorner;
    public double yllcorner;
    public double cellsize;
    public int nodata_value;
    public short[] eval_array;
    private double minlon;
    private double maxlon;
    private double minlat;
    private double maxlat;
    private boolean missingData = false;

    public void init() {
        this.minlon = this.xllcorner;
        this.maxlon = this.minlon + this.cellsize * (double)this.ncols;
        this.minlat = this.yllcorner;
        this.maxlat = this.minlat + this.cellsize * (double)this.nrows;
    }

    public short getElevation(int ilon, int ilat) {
        double lon = (double)ilon / 1000000.0 - 180.0;
        double lat = (double)ilat / 1000000.0 - 90.0;
        double dcol = (lon - this.minlon) / this.cellsize - 0.5;
        double drow = (lat - this.minlat) / this.cellsize - 0.5;
        int row = (int)drow;
        int col = (int)dcol;
        if (col < 0) {
            col = 0;
        }
        if (col >= this.ncols - 1) {
            col = this.ncols - 2;
        }
        if (row < 0) {
            row = 0;
        }
        if (row >= this.nrows - 1) {
            row = this.nrows - 2;
        }
        double wrow = drow - (double)row;
        double wcol = dcol - (double)col;
        this.missingData = false;
        double eval = (1.0 - wrow) * (1.0 - wcol) * (double)this.get(row, col) + wrow * (1.0 - wcol) * (double)this.get(row + 1, col) + (1.0 - wrow) * wcol * (double)this.get(row, col + 1) + wrow * wcol * (double)this.get(row + 1, col + 1);
        return this.missingData ? (short)Short.MIN_VALUE : (short)eval;
    }

    private short get(int r, int c) {
        short e = this.eval_array[r * this.ncols + c];
        if (e == Short.MIN_VALUE) {
            this.missingData = true;
        }
        return e;
    }

    public SrtmData(File file) throws Exception {
        ZipInputStream zis = new ZipInputStream(new FileInputStream(file));
        try {
            ZipEntry ze;
            while (!(ze = zis.getNextEntry()).getName().endsWith(".asc")) {
            }
            this.readFromStream(zis);
            return;
        }
        finally {
            zis.close();
        }
    }

    public void readFromStream(InputStream is) throws Exception {
        int c;
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int linenr = 0;
        while (++linenr <= 6) {
            String line = br.readLine();
            if (linenr == 1) {
                this.ncols = Integer.parseInt(line.substring(14));
                continue;
            }
            if (linenr == 2) {
                this.nrows = Integer.parseInt(line.substring(14));
                continue;
            }
            if (linenr == 3) {
                this.xllcorner = Double.parseDouble(line.substring(14));
                continue;
            }
            if (linenr == 4) {
                this.yllcorner = Double.parseDouble(line.substring(14));
                continue;
            }
            if (linenr == 5) {
                this.cellsize = Double.parseDouble(line.substring(14));
                continue;
            }
            if (linenr != 6) continue;
            this.nodata_value = Integer.parseInt(line.substring(14));
            this.eval_array = new short[this.ncols * this.nrows];
        }
        int row = 0;
        int col = 0;
        int n = 0;
        boolean negative = false;
        while ((c = br.read()) >= 0) {
            if (c == 32) {
                int val;
                if (negative) {
                    n = -n;
                }
                short s = (short)(val = (short)(n == this.nodata_value ? Short.MIN_VALUE : (short)(n * 4)));
                if (val < -1000) {
                    val = Short.MIN_VALUE;
                }
                this.eval_array[(this.nrows - 1 - row) * this.ncols + col] = val;
                if (++col == this.ncols) {
                    col = 0;
                    ++row;
                }
                n = 0;
                negative = false;
                continue;
            }
            if (c >= 48 && c <= 57) {
                n = 10 * n + (c - 48);
                continue;
            }
            if (c != 45) continue;
            negative = true;
        }
        this.init();
        br.close();
    }
}

