/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.NodesList;
import btools.mapaccess.OsmNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public final class OsmNodesMap {
    private HashMap<Long, OsmNode> hmap = new HashMap();
    private NodesList completedNodes = null;
    private int dontCareCount = 0;

    public OsmNode get(long id) {
        return this.hmap.get(new Long(id));
    }

    public void remove(long id) {
        this.hmap.remove(new Long(id));
    }

    public void removeCompletedNodes() {
        NodesList le = this.completedNodes;
        while (le != null) {
            this.remove(le.node.getIdFromPos());
            le = le.next;
        }
        this.completedNodes = null;
    }

    public void registerCompletedNode(OsmNode n) {
        if (n.completed) {
            return;
        }
        n.completed = true;
        NodesList le = new NodesList();
        le.node = n;
        if (this.completedNodes != null) {
            le.next = this.completedNodes;
        }
        this.completedNodes = le;
    }

    public OsmNode put(long id, OsmNode node) {
        return this.hmap.put(new Long(id), node);
    }

    public Collection<OsmNode> nodes() {
        return this.hmap.values();
    }

    public int size() {
        return this.hmap.size();
    }

    public void removeCompleteNodes() {
        if (++this.dontCareCount < 5) {
            return;
        }
        this.dontCareCount = 0;
        ArrayList<OsmNode> delNodes = new ArrayList<OsmNode>();
        for (OsmNode n : this.hmap.values()) {
            if (n.isHollow() || n.hasHollowLinks()) continue;
            delNodes.add(n);
        }
        if (delNodes.size() > 0) {
            for (OsmNode n : delNodes) {
                this.hmap.remove(new Long(n.getIdFromPos()));
            }
        }
    }
}

