/*
 * Decompiled with CFR 0.152.
 */
package btools.mapaccess;

import btools.mapaccess.DistanceChecker;
import btools.mapaccess.OsmFile;
import btools.mapaccess.OsmNode;
import btools.mapaccess.OsmNodesMap;
import java.io.EOFException;
import java.util.ArrayList;
import java.util.List;

final class MicroCache {
    private long[] faid;
    private int[] fapos;
    private int size = 0;
    private int delcount = 0;
    private int delbytes = 0;
    private int p2size;
    private byte[] ab;
    private int aboffset;
    private int ablength;

    public MicroCache(OsmFile segfile, int lonIdx80, int latIdx80, byte[] iobuffer) throws Exception {
        int lonDegree = lonIdx80 / 80;
        int latDegree = latIdx80 / 80;
        int lonIdxBase = lonIdx80 / 5 * 62500 + 31250;
        int latIdxBase = latIdx80 / 5 * 62500 + 31250;
        int subIdx = (latIdx80 - 80 * latDegree) * 80 + (lonIdx80 - 80 * lonDegree);
        try {
            this.ab = iobuffer;
            int asize = segfile.getDataInputForSubIdx(subIdx, this.ab);
            if (asize == 0) {
                return;
            }
            if (asize > iobuffer.length) {
                this.ab = new byte[asize];
                asize = segfile.getDataInputForSubIdx(subIdx, this.ab);
            }
            this.aboffset = 0;
            this.size = this.readInt();
            byte[] nab = new byte[asize - 4 - this.size * 8];
            int noffset = 0;
            this.faid = new long[this.size];
            this.fapos = new int[this.size];
            this.p2size = 0x40000000;
            while (this.p2size > this.size) {
                this.p2size >>= 1;
            }
            int i = 0;
            while (i < this.size) {
                long nodeId;
                int ilon = this.readShort();
                int ilat = this.readShort();
                this.faid[i] = nodeId = (long)(ilon += lonIdxBase) << 32 | (long)(ilat += latIdxBase);
                int bodySize = this.readInt();
                this.fapos[i] = noffset;
                System.arraycopy(this.ab, this.aboffset, nab, noffset, bodySize);
                this.aboffset += bodySize;
                noffset += bodySize;
                ++i;
            }
            this.ab = nab;
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private boolean getAndClear(long id) {
        if (this.size == 0) {
            return false;
        }
        long[] a = this.faid;
        int offset = this.p2size;
        int n = 0;
        while (offset > 0) {
            int nn = n + offset;
            if (nn < this.size && a[nn] <= id) {
                n = nn;
            }
            offset >>= 1;
        }
        if (a[n] == id) {
            if ((this.fapos[n] & Integer.MIN_VALUE) == 0) {
                this.aboffset = this.fapos[n];
                this.ablength = (n + 1 < this.size ? this.fapos[n + 1] & Integer.MAX_VALUE : this.ab.length) - this.aboffset;
                int n2 = n;
                this.fapos[n2] = this.fapos[n2] | Integer.MIN_VALUE;
                this.delbytes += this.ablength;
                ++this.delcount;
                return true;
            }
            throw new RuntimeException("MicroCache: node already consumed: id=" + id);
        }
        return false;
    }

    public void fillNode(OsmNode node, OsmNodesMap nodesMap, DistanceChecker dc) {
        long id = node.getIdFromPos();
        if (this.getAndClear(id)) {
            node.parseNodeBody(this, this.ablength, nodesMap, dc);
        }
        if (this.delcount > this.size / 2) {
            int nsize = this.size - this.delcount;
            if (nsize == 0) {
                this.faid = null;
                this.fapos = null;
            } else {
                long[] nfaid = new long[nsize];
                int[] nfapos = new int[nsize];
                int idx = 0;
                byte[] nab = new byte[this.ab.length - this.delbytes];
                int nab_off = 0;
                int i = 0;
                while (i < this.size) {
                    int pos = this.fapos[i];
                    if ((pos & Integer.MIN_VALUE) == 0) {
                        this.ablength = (i + 1 < this.size ? this.fapos[i + 1] & Integer.MAX_VALUE : this.ab.length) - pos;
                        System.arraycopy(this.ab, pos, nab, nab_off, this.ablength);
                        nfaid[idx] = this.faid[i];
                        nfapos[idx] = nab_off;
                        nab_off += this.ablength;
                        ++idx;
                    }
                    ++i;
                }
                this.faid = nfaid;
                this.fapos = nfapos;
                this.ab = nab;
            }
            this.size = nsize;
            this.delcount = 0;
            this.delbytes = 0;
            this.p2size = 0x40000000;
            while (this.p2size > this.size) {
                this.p2size >>= 1;
            }
        }
    }

    public List<OsmNode> getPositions(OsmNodesMap nodesMap) {
        ArrayList<OsmNode> positions = new ArrayList<OsmNode>();
        int i = 0;
        while (i < this.size) {
            OsmNode n = new OsmNode(this.faid[i]);
            n.setHollow();
            nodesMap.put(this.faid[i], n);
            positions.add(n);
            ++i;
        }
        return positions;
    }

    public int readInt() {
        int i3 = this.ab[this.aboffset++] & 0xFF;
        int i2 = this.ab[this.aboffset++] & 0xFF;
        int i1 = this.ab[this.aboffset++] & 0xFF;
        int i0 = this.ab[this.aboffset++] & 0xFF;
        return (i3 << 24) + (i2 << 16) + (i1 << 8) + i0;
    }

    public long readLong() {
        long i7 = this.ab[this.aboffset++] & 0xFF;
        long i6 = this.ab[this.aboffset++] & 0xFF;
        long i5 = this.ab[this.aboffset++] & 0xFF;
        long i4 = this.ab[this.aboffset++] & 0xFF;
        long i3 = this.ab[this.aboffset++] & 0xFF;
        long i2 = this.ab[this.aboffset++] & 0xFF;
        long i1 = this.ab[this.aboffset++] & 0xFF;
        long i0 = this.ab[this.aboffset++] & 0xFF;
        return (i7 << 56) + (i6 << 48) + (i5 << 40) + (i4 << 32) + (i3 << 24) + (i2 << 16) + (i1 << 8) + i0;
    }

    public boolean readBoolean() {
        int i0;
        return (i0 = this.ab[this.aboffset++] & 0xFF) != 0;
    }

    public byte readByte() {
        int i0 = this.ab[this.aboffset++] & 0xFF;
        return (byte)i0;
    }

    public short readShort() {
        int i1 = this.ab[this.aboffset++] & 0xFF;
        int i0 = this.ab[this.aboffset++] & 0xFF;
        return (short)(i1 << 8 | i0);
    }
}

