/*
 * Decompiled with CFR 0.152.
 */
package btools.expressions;

import btools.expressions.BExpression;
import btools.expressions.BExpressionLookupValue;
import btools.expressions.BExpressionReceiver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class BExpressionContext {
    private static final String CONTEXT_TAG = "---context:";
    private static final String VERSION_TAG = "---lookupversion:";
    private String context;
    private boolean _inOurContext = false;
    private BufferedReader _br = null;
    private boolean _readerDone = false;
    private BExpressionReceiver _receiver;
    private Map<String, Integer> lookupNumbers = new HashMap<String, Integer>();
    private ArrayList<BExpressionLookupValue[]> lookupValues = new ArrayList();
    private ArrayList<String> lookupNames = new ArrayList();
    private ArrayList<int[]> lookupHistograms = new ArrayList();
    private boolean lookupDataFrozen = false;
    private int[] lookupData = new int[0];
    private Map<String, Integer> variableNumbers = new HashMap<String, Integer>();
    private float[] variableData;
    private long[] _arrayBitmap;
    private int currentHashBucket = -1;
    private long currentBitmap = 0L;
    public List<BExpression> expressionList;
    private int minWriteIdx;
    private int costfactorIdx;
    private int turncostIdx;
    private int initialcostIdx;
    private float[] _arrayCostfactor;
    private float[] _arrayTurncost;
    private float[] _arrayInitialcost;
    private int linenr;
    public short lookupVersion = (short)-1;
    private static int[] crctable;

    static {
        int[] nArray = new int[256];
        nArray[1] = 1996959894;
        nArray[2] = -301047508;
        nArray[3] = -1727442502;
        nArray[4] = 124634137;
        nArray[5] = 1886057615;
        nArray[6] = -379345611;
        nArray[7] = -1637575261;
        nArray[8] = 249268274;
        nArray[9] = 2044508324;
        nArray[10] = -522852066;
        nArray[11] = -1747789432;
        nArray[12] = 162941995;
        nArray[13] = 2125561021;
        nArray[14] = -407360249;
        nArray[15] = -1866523247;
        nArray[16] = 498536548;
        nArray[17] = 1789927666;
        nArray[18] = -205950648;
        nArray[19] = -2067906082;
        nArray[20] = 450548861;
        nArray[21] = 1843258603;
        nArray[22] = -187386543;
        nArray[23] = -2083289657;
        nArray[24] = 325883990;
        nArray[25] = 1684777152;
        nArray[26] = -43845254;
        nArray[27] = -1973040660;
        nArray[28] = 335633487;
        nArray[29] = 1661365465;
        nArray[30] = -99664541;
        nArray[31] = -1928851979;
        nArray[32] = 997073096;
        nArray[33] = 1281953886;
        nArray[34] = -715111964;
        nArray[35] = -1570279054;
        nArray[36] = 1006888145;
        nArray[37] = 1258607687;
        nArray[38] = -770865667;
        nArray[39] = -1526024853;
        nArray[40] = 901097722;
        nArray[41] = 1119000684;
        nArray[42] = -608450090;
        nArray[43] = -1396901568;
        nArray[44] = 853044451;
        nArray[45] = 1172266101;
        nArray[46] = -589951537;
        nArray[47] = -1412350631;
        nArray[48] = 651767980;
        nArray[49] = 1373503546;
        nArray[50] = -925412992;
        nArray[51] = -1076862698;
        nArray[52] = 565507253;
        nArray[53] = 1454621731;
        nArray[54] = -809855591;
        nArray[55] = -1195530993;
        nArray[56] = 671266974;
        nArray[57] = 1594198024;
        nArray[58] = -972236366;
        nArray[59] = -1324619484;
        nArray[60] = 795835527;
        nArray[61] = 1483230225;
        nArray[62] = -1050600021;
        nArray[63] = -1234817731;
        nArray[64] = 1994146192;
        nArray[65] = 31158534;
        nArray[66] = -1731059524;
        nArray[67] = -271249366;
        nArray[68] = 1907459465;
        nArray[69] = 112637215;
        nArray[70] = -1614814043;
        nArray[71] = -390540237;
        nArray[72] = 2013776290;
        nArray[73] = 251722036;
        nArray[74] = -1777751922;
        nArray[75] = -519137256;
        nArray[76] = 2137656763;
        nArray[77] = 141376813;
        nArray[78] = -1855689577;
        nArray[79] = -429695999;
        nArray[80] = 1802195444;
        nArray[81] = 476864866;
        nArray[82] = -2056965928;
        nArray[83] = -228458418;
        nArray[84] = 1812370925;
        nArray[85] = 453092731;
        nArray[86] = -2113342271;
        nArray[87] = -183516073;
        nArray[88] = 1706088902;
        nArray[89] = 314042704;
        nArray[90] = -1950435094;
        nArray[91] = -54949764;
        nArray[92] = 1658658271;
        nArray[93] = 366619977;
        nArray[94] = -1932296973;
        nArray[95] = -69972891;
        nArray[96] = 1303535960;
        nArray[97] = 984961486;
        nArray[98] = -1547960204;
        nArray[99] = -725929758;
        nArray[100] = 1256170817;
        nArray[101] = 1037604311;
        nArray[102] = -1529756563;
        nArray[103] = -740887301;
        nArray[104] = 1131014506;
        nArray[105] = 879679996;
        nArray[106] = -1385723834;
        nArray[107] = -631195440;
        nArray[108] = 1141124467;
        nArray[109] = 855842277;
        nArray[110] = -1442165665;
        nArray[111] = -586318647;
        nArray[112] = 1342533948;
        nArray[113] = 654459306;
        nArray[114] = -1106571248;
        nArray[115] = -921952122;
        nArray[116] = 1466479909;
        nArray[117] = 544179635;
        nArray[118] = -1184443383;
        nArray[119] = -832445281;
        nArray[120] = 1591671054;
        nArray[121] = 702138776;
        nArray[122] = -1328506846;
        nArray[123] = -942167884;
        nArray[124] = 1504918807;
        nArray[125] = 783551873;
        nArray[126] = -1212326853;
        nArray[127] = -1061524307;
        nArray[128] = -306674912;
        nArray[129] = -1698712650;
        nArray[130] = 62317068;
        nArray[131] = 1957810842;
        nArray[132] = -355121351;
        nArray[133] = -1647151185;
        nArray[134] = 81470997;
        nArray[135] = 1943803523;
        nArray[136] = -480048366;
        nArray[137] = -1805370492;
        nArray[138] = 225274430;
        nArray[139] = 2053790376;
        nArray[140] = -468791541;
        nArray[141] = -1828061283;
        nArray[142] = 167816743;
        nArray[143] = 2097651377;
        nArray[144] = -267414716;
        nArray[145] = -2029476910;
        nArray[146] = 503444072;
        nArray[147] = 1762050814;
        nArray[148] = -144550051;
        nArray[149] = -2140837941;
        nArray[150] = 426522225;
        nArray[151] = 1852507879;
        nArray[152] = -19653770;
        nArray[153] = -1982649376;
        nArray[154] = 282753626;
        nArray[155] = 1742555852;
        nArray[156] = -105259153;
        nArray[157] = -1900089351;
        nArray[158] = 397917763;
        nArray[159] = 1622183637;
        nArray[160] = -690576408;
        nArray[161] = -1580100738;
        nArray[162] = 953729732;
        nArray[163] = 1340076626;
        nArray[164] = -776247311;
        nArray[165] = -1497606297;
        nArray[166] = 1068828381;
        nArray[167] = 1219638859;
        nArray[168] = -670225446;
        nArray[169] = -1358292148;
        nArray[170] = 906185462;
        nArray[171] = 1090812512;
        nArray[172] = -547295293;
        nArray[173] = -1469587627;
        nArray[174] = 829329135;
        nArray[175] = 1181335161;
        nArray[176] = -882789492;
        nArray[177] = -1134132454;
        nArray[178] = 628085408;
        nArray[179] = 1382605366;
        nArray[180] = -871598187;
        nArray[181] = -1156888829;
        nArray[182] = 570562233;
        nArray[183] = 1426400815;
        nArray[184] = -977650754;
        nArray[185] = -1296233688;
        nArray[186] = 733239954;
        nArray[187] = 1555261956;
        nArray[188] = -1026031705;
        nArray[189] = -1244606671;
        nArray[190] = 752459403;
        nArray[191] = 1541320221;
        nArray[192] = -1687895376;
        nArray[193] = -328994266;
        nArray[194] = 1969922972;
        nArray[195] = 40735498;
        nArray[196] = -1677130071;
        nArray[197] = -351390145;
        nArray[198] = 1913087877;
        nArray[199] = 83908371;
        nArray[200] = -1782625662;
        nArray[201] = -491226604;
        nArray[202] = 2075208622;
        nArray[203] = 213261112;
        nArray[204] = -1831694693;
        nArray[205] = -438977011;
        nArray[206] = 2094854071;
        nArray[207] = 198958881;
        nArray[208] = -2032938284;
        nArray[209] = -237706686;
        nArray[210] = 1759359992;
        nArray[211] = 534414190;
        nArray[212] = -2118248755;
        nArray[213] = -155638181;
        nArray[214] = 1873836001;
        nArray[215] = 414664567;
        nArray[216] = -2012718362;
        nArray[217] = -15766928;
        nArray[218] = 1711684554;
        nArray[219] = 285281116;
        nArray[220] = -1889165569;
        nArray[221] = -127750551;
        nArray[222] = 1634467795;
        nArray[223] = 376229701;
        nArray[224] = -1609899400;
        nArray[225] = -686959890;
        nArray[226] = 1308918612;
        nArray[227] = 956543938;
        nArray[228] = -1486412191;
        nArray[229] = -799009033;
        nArray[230] = 1231636301;
        nArray[231] = 1047427035;
        nArray[232] = -1362007478;
        nArray[233] = -640263460;
        nArray[234] = 1088359270;
        nArray[235] = 936918000;
        nArray[236] = -1447252397;
        nArray[237] = -558129467;
        nArray[238] = 1202900863;
        nArray[239] = 817233897;
        nArray[240] = -1111625188;
        nArray[241] = -893730166;
        nArray[242] = 1404277552;
        nArray[243] = 615818150;
        nArray[244] = -1160759803;
        nArray[245] = -841546093;
        nArray[246] = 1423857449;
        nArray[247] = 601450431;
        nArray[248] = -1285129682;
        nArray[249] = -1000256840;
        nArray[250] = 1567103746;
        nArray[251] = 711928724;
        nArray[252] = -1274298825;
        nArray[253] = -1022587231;
        nArray[254] = 1510334235;
        nArray[255] = 755167117;
        crctable = nArray;
    }

    public float getCostfactor() {
        return this._arrayCostfactor[this.currentHashBucket];
    }

    public float getTurncost() {
        return this._arrayTurncost[this.currentHashBucket];
    }

    public float getInitialcost() {
        return this._arrayInitialcost[this.currentHashBucket];
    }

    public BExpressionContext(String context) {
        this(context, 4096);
    }

    public BExpressionContext(String context, int hashSize) {
        this.context = context;
        this._arrayBitmap = new long[hashSize];
        this._arrayCostfactor = new float[hashSize];
        this._arrayTurncost = new float[hashSize];
        this._arrayInitialcost = new float[hashSize];
    }

    public long encode(int[] ld) {
        long w = 0L;
        int inum = 0;
        while (inum < this.lookupValues.size()) {
            int n = this.lookupValues.get(inum).length - 1;
            int d = ld[inum];
            if (n == 2) {
                n = 1;
                d = d == 2 ? 1 : 0;
            }
            while (n != 0) {
                n >>= 1;
                w <<= 1;
            }
            w |= (long)d;
            ++inum;
        }
        return w;
    }

    public void decode(int[] ld, long w) {
        int inum = this.lookupValues.size() - 1;
        while (inum >= 0) {
            int nv = this.lookupValues.get(inum).length;
            int n = nv == 3 ? 1 : nv - 1;
            int m = 0;
            long ww = w;
            while (n != 0) {
                n >>= 1;
                ww >>= 1;
                m = m << 1 | 1;
            }
            int d = (int)(w & (long)m);
            if (nv == 3 && d == 1) {
                d = 2;
            }
            ld[inum] = d;
            w = ww;
            --inum;
        }
    }

    private void countBits() {
        int bits = 0;
        int inum = this.lookupValues.size() - 1;
        while (inum >= 0) {
            int nv = this.lookupValues.get(inum).length;
            int n = nv == 3 ? 1 : nv - 1;
            while (n != 0) {
                n >>= 1;
                ++bits;
            }
            --inum;
        }
        if (bits > 64) {
            throw new IllegalArgumentException("lookup table for context " + this.context + " exceeds 64 bits!");
        }
    }

    public String getCsvDescription(long bitmap) {
        StringBuilder sb = new StringBuilder(200);
        this.decode(this.lookupData, bitmap);
        int inum = 0;
        while (inum < this.lookupValues.size()) {
            BExpressionLookupValue[] va = this.lookupValues.get(inum);
            sb.append('\t').append(va[this.lookupData[inum]].toString());
            ++inum;
        }
        return sb.toString();
    }

    public String getCsvHeader() {
        StringBuilder sb = new StringBuilder(200);
        for (String name : this.lookupNames) {
            sb.append('\t').append(name);
        }
        return sb.toString();
    }

    public void readMetaData(File lookupsFile) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(lookupsFile));
            int parsedLines = 0;
            boolean ourContext = false;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith(CONTEXT_TAG)) {
                    ourContext = line.substring(CONTEXT_TAG.length()).equals(this.context);
                    continue;
                }
                if (line.startsWith(VERSION_TAG)) {
                    this.lookupVersion = Short.parseShort(line.substring(VERSION_TAG.length()));
                    continue;
                }
                if (!ourContext) continue;
                ++parsedLines;
                StringTokenizer tk = new StringTokenizer(line, " ");
                String name = tk.nextToken();
                String value = tk.nextToken();
                int idx = name.indexOf(59);
                if (idx >= 0) {
                    name = name.substring(0, idx);
                }
                BExpressionLookupValue newValue = this.addLookupValue(name, value, null);
                while (newValue != null && tk.hasMoreTokens()) {
                    newValue.addAlias(tk.nextToken());
                }
            }
            br.close();
            if (parsedLines == 0 && !"global".equals(this.context)) {
                throw new IllegalArgumentException(String.valueOf(lookupsFile.getAbsolutePath()) + " does not contain data for context " + this.context + " (old version?)");
            }
            this.lookupDataFrozen = true;
            this.countBits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void evaluate(int[] lookupData2) {
        this.lookupData = lookupData2;
        for (BExpression exp : this.expressionList) {
            exp.evaluate(this);
        }
    }

    public void evaluate(long bitmap, BExpressionReceiver receiver) {
        this._receiver = receiver;
        if (this.currentBitmap != bitmap || this.currentHashBucket < 0) {
            int crc = -1;
            long bm = bitmap;
            int j = 0;
            while (j < 8) {
                crc = crc >>> 8 ^ crctable[(crc ^ (int)bm) & 0xFF];
                bm >>= 8;
                ++j;
            }
            int hashSize = this._arrayBitmap.length;
            this.currentHashBucket = (crc & 0xFFFFFFF) % hashSize;
            this.currentBitmap = bitmap;
        }
        if (this._arrayBitmap[this.currentHashBucket] == bitmap) {
            return;
        }
        this._arrayBitmap[this.currentHashBucket] = bitmap;
        this.decode(this.lookupData, bitmap);
        this.evaluate(this.lookupData);
        this._arrayCostfactor[this.currentHashBucket] = this.variableData[this.costfactorIdx];
        this._arrayTurncost[this.currentHashBucket] = this.variableData[this.turncostIdx];
        this._arrayInitialcost[this.currentHashBucket] = this.variableData[this.initialcostIdx];
        this._receiver = null;
    }

    public void dumpStatistics() {
        int[] histo;
        TreeMap<String, String> counts = new TreeMap<String, String>();
        for (String name : this.lookupNumbers.keySet()) {
            int cnt = 0;
            int inum = this.lookupNumbers.get(name);
            histo = this.lookupHistograms.get(inum);
            int i = 2;
            while (i < histo.length) {
                cnt += histo[i];
                ++i;
            }
            counts.put(1000000000 + cnt + "_" + name, name);
        }
        while (counts.size() > 0) {
            String key = (String)counts.lastEntry().getKey();
            String name = (String)counts.get(key);
            counts.remove(key);
            int inum = this.lookupNumbers.get(name);
            BExpressionLookupValue[] values = this.lookupValues.get(inum);
            histo = this.lookupHistograms.get(inum);
            if (values.length == 1000) continue;
            Object[] svalues = new String[values.length];
            int i = 0;
            while (i < values.length) {
                String scnt = "0000000000" + histo[i];
                scnt = scnt.substring(scnt.length() - 10);
                svalues[i] = String.valueOf(scnt) + " " + values[i].toString();
                ++i;
            }
            Arrays.sort(svalues);
            i = svalues.length - 1;
            while (i >= 0) {
                System.out.println(String.valueOf(name) + ";" + (String)svalues[i]);
                --i;
            }
        }
    }

    public int[] createNewLookupData() {
        if (this.lookupDataFrozen) {
            return new int[this.lookupValues.size()];
        }
        return null;
    }

    public BExpressionLookupValue addLookupValue(String name, String value, int[] lookupData2) {
        BExpressionLookupValue newValue = null;
        Integer num = this.lookupNumbers.get(name);
        if (num == null) {
            if (lookupData2 != null) {
                return newValue;
            }
            num = new Integer(this.lookupValues.size());
            this.lookupNumbers.put(name, num);
            this.lookupNames.add(name);
            this.lookupValues.add(new BExpressionLookupValue[]{new BExpressionLookupValue(""), new BExpressionLookupValue("unknown")});
            this.lookupHistograms.add(new int[2]);
            int[] ndata = new int[this.lookupData.length + 1];
            System.arraycopy(this.lookupData, 0, ndata, 0, this.lookupData.length);
            this.lookupData = ndata;
        }
        int inum = num;
        BExpressionLookupValue[] values = this.lookupValues.get(inum);
        int[] histo = this.lookupHistograms.get(inum);
        int i = 0;
        while (i < values.length) {
            BExpressionLookupValue v = values[i];
            if (v.matches(value)) break;
            ++i;
        }
        if (i == values.length) {
            if (lookupData2 != null) {
                lookupData2[inum] = 1;
                return newValue;
            }
            if (i == 500) {
                return newValue;
            }
            BExpressionLookupValue[] nvalues = new BExpressionLookupValue[values.length + 1];
            int[] nhisto = new int[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            System.arraycopy(histo, 0, nhisto, 0, histo.length);
            values = nvalues;
            histo = nhisto;
            values[i] = newValue = new BExpressionLookupValue(value);
            this.lookupHistograms.set(inum, histo);
            this.lookupValues.set(inum, values);
        }
        int n = i;
        histo[n] = histo[n] + 1;
        if (lookupData2 != null) {
            lookupData2[inum] = i;
        } else {
            this.lookupData[inum] = i;
        }
        return newValue;
    }

    public void parseFile(File file, String readOnlyContext) {
        try {
            if (readOnlyContext != null) {
                this.linenr = 1;
                String realContext = this.context;
                this.context = readOnlyContext;
                this.expressionList = this._parseFile(file);
                this.variableData = new float[this.variableNumbers.size()];
                this.evaluate(1L, null);
                this.context = realContext;
            }
            this.linenr = 1;
            this.minWriteIdx = this.variableData == null ? 0 : this.variableData.length;
            this.costfactorIdx = this.getVariableIdx("costfactor", true);
            this.turncostIdx = this.getVariableIdx("turncost", true);
            this.initialcostIdx = this.getVariableIdx("initialcost", true);
            this.expressionList = this._parseFile(file);
            float[] readOnlyData = this.variableData;
            this.variableData = new float[this.variableNumbers.size()];
            int i = 0;
            while (i < this.minWriteIdx) {
                this.variableData[i] = readOnlyData[i];
                ++i;
            }
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new IllegalArgumentException("ParseException at line " + this.linenr + ": " + e.getMessage());
            }
            throw new RuntimeException(e);
        }
        if (this.expressionList.size() == 0) {
            throw new IllegalArgumentException(String.valueOf(file.getAbsolutePath()) + " does not contain expressions for context " + this.context + " (old version?)");
        }
    }

    private List<BExpression> _parseFile(File file) throws Exception {
        BExpression exp;
        this._br = new BufferedReader(new FileReader(file));
        this._readerDone = false;
        ArrayList<BExpression> result = new ArrayList<BExpression>();
        while ((exp = BExpression.parse(this, 0)) != null) {
            result.add(exp);
        }
        this._br.close();
        this._br = null;
        return result;
    }

    public float getVariableValue(String name) {
        Integer num = this.variableNumbers.get(name);
        return num == null ? 0.0f : this.getVariableValue(num);
    }

    public float getVariableValue(int variableIdx) {
        return this.variableData[variableIdx];
    }

    public int getVariableIdx(String name, boolean create) {
        Integer num = this.variableNumbers.get(name);
        if (num == null) {
            if (create) {
                num = new Integer(this.variableNumbers.size());
                this.variableNumbers.put(name, num);
            } else {
                return -1;
            }
        }
        return num;
    }

    public int getMinWriteIdx() {
        return this.minWriteIdx;
    }

    public float getLookupMatch(int nameIdx, int valueIdx) {
        return this.lookupData[nameIdx] == valueIdx ? 1.0f : 0.0f;
    }

    public int getLookupNameIdx(String name) {
        Integer num = this.lookupNumbers.get(name);
        return num == null ? -1 : num;
    }

    public int getLookupValueIdx(int nameIdx, String value) {
        BExpressionLookupValue[] values = this.lookupValues.get(nameIdx);
        int i = 0;
        while (i < values.length) {
            if (values[i].equals(value)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String parseToken() throws Exception {
        String token;
        while (true) {
            if ((token = this._parseToken()) == null) {
                return null;
            }
            if (token.startsWith(CONTEXT_TAG)) {
                this._inOurContext = token.substring(CONTEXT_TAG.length()).equals(this.context);
                continue;
            }
            if (this._inOurContext) break;
        }
        return token;
    }

    private String _parseToken() throws Exception {
        StringBuilder sb = new StringBuilder(32);
        boolean inComment = false;
        while (true) {
            int ic;
            int n = ic = this._readerDone ? -1 : this._br.read();
            if (ic < 0) {
                if (sb.length() == 0) {
                    return null;
                }
                this._readerDone = true;
                return sb.toString();
            }
            char c = (char)ic;
            if (c == '\n') {
                ++this.linenr;
            }
            if (inComment) {
                if (c != '\r' && c != '\n') continue;
                inComment = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                return sb.toString();
            }
            if (c == '#' && sb.length() == 0) {
                inComment = true;
                continue;
            }
            sb.append(c);
        }
    }

    public float assign(int variableIdx, float value) {
        this.variableData[variableIdx] = value;
        return value;
    }

    public void expressionWarning(String message) {
        this._arrayBitmap[this.currentHashBucket] = 0L;
        if (this._receiver != null) {
            this._receiver.expressionWarning(this.context, message);
        }
    }
}

